<?php

    // First we execute our common code to connection to the database and start the session
    include_once ($_SERVER["DOCUMENT_ROOT"]."/_libraries/b0-login/common.php");
    include_once ($_SERVER["DOCUMENT_ROOT"]."/_libraries/functions.php");

    // At the top of the page we check to see whether the user is logged in or not
    if(empty($_SESSION['user']))
    {
        // If they are not, we redirect them to the login page.
        header("Location: /");

        // Remember that this die statement is absolutely critical.  Without it,
        // people can view your members-only content without logging in.
        die("Redirecting to login page.");
    } else {
        if(empty($_POST['action'])){
            $smarty->assign( 'loggedIn', '1');
 
            $smarty->assign( 'first_name', $_SESSION['user']['first_name']);
            $smarty->assign( 'last_name', $_SESSION['user']['last_name']);
            $smarty->assign( 'first_name_letter', $_SESSION['user']['first_name'][0]);
            $smarty->assign( 'last_name_letter', $_SESSION['user']['last_name'][0]);
            $smarty->assign( 'isAdmin', $_SESSION['user']['admin']);
            $smarty->assign( 'allView', $_SESSION['user']['allview']);
            $smarty->assign( 'userRole',  $_SESSION['user']['role'] );
            $smarty->assign( 'job',  $_SESSION['user']['job'] );
            $smarty->assign( 'systems',  $_SESSION['user']['systems'] );
            
            $smarty->assign( 'obligations',  $_SESSION['user']['obligations'] );
            $smarty->assign( 'obligations_arr',  $_SESSION['user']['obligations_arr'] );

            $smarty->assign( 'dedicated_clients',  $_SESSION['user']['clients'] );
            $smarty->assign( 'dedicated_clients_arr',  $_SESSION['user']['clients_arr'] );
            
            // Token
            $smarty->assign( 'userToken',  $_SESSION['user']['token'] );
            $smarty->assign( 'userTokenExpiration',  $_SESSION['user']['tokenExpiration'] );

            $smarty->assign( 'userType', $_SESSION['user']['user_type']);
            $smarty->assign( 'userId', $_SESSION['user']['id']);
            $smarty->assign( 'userUid', $_SESSION['user']['uid']);
            $smarty->assign( 'userEmail', $_SESSION['user']['email']);
            $smarty->assign( 'userCity', $_SESSION['user']['city']);
            $smarty->assign( 'userCountry', $_SESSION['user']['country']);
            $smarty->assign( 'userCompany', $_SESSION['user']['company']);
            $smarty->assign( 'userPhone', $_SESSION['user']['phone']);

            $smarty->assign( 'userGravatar', $_SESSION['user']['gravatar']);
            $smarty->assign( 'userGravatarLarge', $_SESSION['user']['gravatarLarge']);

            
//            $smarty->assign( 'plansConfig',  $GLOBALS['plansConfig'] );
//            $smarty->assign( 'currentPlansConfig',  $GLOBALS['plansConfig'][$_SESSION['user']['plan']] );

            // Get all users projects and save it to Cookie
            // So we can call it through out the application
            //set_project_domain_cookie();

        }

    }

    // Everything below this point in the file is secured by the login system

    // We can display the user's username to them by reading it from the session array.  Remember that because
    // a username is user submitted content we must use htmlentities on it before displaying it to the user.
