<?php

    // First we execute our common code to connection to the database and start the session
    require($_SERVER["DOCUMENT_ROOT"]."/_libraries/b0-login/common.php");


    /* Functions
    **************************************************** */
    include_once ($_SERVER["DOCUMENT_ROOT"]."/_libraries/functions.php");
    include_once ($_SERVER["DOCUMENT_ROOT"]."/_libraries/b0-login/bootstrap.inc");
    include_once ($_SERVER["DOCUMENT_ROOT"]."/_libraries/b0-login/password.inc");

    // This if statement checks to determine whether the registration form has been submitted
    // If it has, then the registration code is run, otherwise the form is displayed
    if(!empty($_POST))
    {
        
        $reg_ok = true;
        
        // Ensure that the user has entered a non-empty username
//        if(empty($_POST['username']))
//        {
//            // Note that die() is generally a terrible way of handling user errors
//            // like this.  It is much better to display the error with the form
//            // and allow the user to correct their mistake.  However, that is an
//            // exercise for you to implement yourself.
//            //die("Please enter a username.");
//            $smarty->assign( 'error', 'Please check your data and try again.' );
//        }

        // Ensure that the user has entered a non-empty password
        if(empty($_POST['password'])) { $smarty->assign( 'register_error', 'Please check your data and try again.' ); }
        if(empty($_POST['fullname'])) { $smarty->assign( 'register_error', 'Please check your data and try again.' ); }
        if(empty($_POST['email'])) { $smarty->assign( 'register_error', 'Please check your data and try again.' ); }
        if(empty($_POST['country'])) { $country = NULL; } else { $country = $_POST['country']; }
        if(empty($_POST['telephone'])) { $telephone = NULL; } else { $telephone = $_POST['telephone']; }
        if(empty($_POST['company'])) { $company = NULL; } else { $company = $_POST['company']; }
        if(empty($_POST['city'])) { $city = NULL; } else { $city = $_POST['city']; }
        if(empty($_POST['type'])) { $user_type = NULL; } else { $user_type = $_POST['type']; }

        // Make sure the user entered a valid E-Mail address
        // filter_var is a useful PHP function for validating form input, see:
        // http://us.php.net/manual/en/function.filter-var.php
        // http://us.php.net/manual/en/filter.filters.php
        if(!filter_var($_POST['email'], FILTER_VALIDATE_EMAIL))
        {
//            die("Invalid E-Mail Address");
            $smarty->assign( 'register_error', $GLOBALS['lang']['validation_check_data'] );
            $reg_ok = false;

        }

        // We will use this SQL query to see whether the username entered by the
        // user is already in use.  A SELECT query is used to retrieve data from the database.
        // :username is a special token, we will substitute a real value in its place when
        // we execute the query.
//        $query = "
//            SELECT
//                1
//            FROM ".$GLOBALS['db_prefix']."users
//            WHERE
//                username = :username
//        ";

        // This contains the definitions for any special tokens that we place in
        // our SQL query.  In this case, we are defining a value for the token
        // :username.  It is possible to insert $_POST['username'] directly into
        // your $query string; however doing so is very insecure and opens your
        // code up to SQL injection exploits.  Using tokens prevents this.
        // For more information on SQL injections, see Wikipedia:
        // http://en.wikipedia.org/wiki/SQL_Injection
//        $query_params = array(
//            ':username' => $_POST['username']
//        );
//
//        try
//        {
            // These two statements run the query against your database table.
//            $stmt = $db->prepare($query);
//            $result = $stmt->execute($query_params);
//        }
//        catch(PDOException $ex)
//        {
            // Note: On a production website, you should not output $ex->getMessage().
            // It may provide an attacker with helpful information about your code.
//            die("Failed to run query: " . $ex->getMessage());
//            $smarty->assign( 'error', 'Failed to run query: ' . $ex->getMessage() );
//        }

        // The fetch() method returns an array representing the "next" row from
        // the selected results, or false if there are no more rows to fetch.
//        $row = $stmt->fetch();

        // If a row was returned, then we know a matching username was found in
        // the database already and we should not allow the user to continue.
//        if($row)
//        {
//            die("This username is already in use");
//            $smarty->assign( 'error', 'Username already in use. Please try another one.');
//        }

        // Now we perform the same type of check for the email address, in order
        // to ensure that it is unique.
        $query = "
            SELECT
                1
            FROM ".$GLOBALS['db_prefix']."users
            WHERE
                email = :email
        ";

        $query_params = array(
            ':email' => $_POST['email']
        );

        try
        {
            $stmt = $db->prepare($query);
            $result = $stmt->execute($query_params);
        }
        catch(PDOException $ex)
        {
//            die("Failed to run query: " . $ex->getMessage());
//            $smarty->assign( 'error', 'Failed to run query: ' . $ex->getMessage());
            $smarty->assign( 'register_error', $GLOBALS['lang']['something_happend']);
        }

        $row = $stmt->fetch();

        if($row)
        {
//            die("This email address is already registered");
            $smarty->assign( 'register_error', $GLOBALS['lang']['validation_user_in_use']);
            $reg_ok = false;

        }
        

        if($reg_ok != false) {

                // An INSERT query is used to add new rows to a database table.
                // Again, we are using special tokens (technically called parameters) to
                // protect against SQL injection attacks.
                $date_created = time();
                $query = "
                    INSERT INTO ".$GLOBALS['db_prefix']."users (
                        fullname,
                        password,
                        country,
                        city,
                        company,
                        telephone,
                        user_type,
                        email,
                        created,
                        active,
                        status
                    ) VALUES (
                        :fullname,
                        :password,
                        :country,
                        :city,
                        :company,
                        :telephone,
                        :user_type,
                        :email,
                        :created,
                        1,
                        1
                    )
                ";


                // A salt is randomly generated here to protect again brute force attacks
                // and rainbow table attacks.  The following statement generates a hex
                // representation of an 8 byte salt.  Representing this in hex provides
                // no additional security, but makes it easier for humans to read.
                // For more information:
                // http://en.wikipedia.org/wiki/Salt_%28cryptography%29
                // http://en.wikipedia.org/wiki/Brute-force_attack
                // http://en.wikipedia.org/wiki/Rainbow_table
                // $salt = dechex(mt_rand(0, 2147483647)) . dechex(mt_rand(0, 2147483647));

                // This hashes the password with the salt so that it can be stored securely
                // in your database.  The output of this next statement is a 64 byte hex
                // string representing the 32 byte sha256 hash of the password.  The original
                // password cannot be recovered from the hash.  For more information:
                // http://en.wikipedia.org/wiki/Cryptographic_hash_function
                // $password = hash('sha256', $_POST['password'] . $salt);

                // Next we hash the hash value 65536 more times.  The purpose of this is to
                // protect against brute force attacks.  Now an attacker must compute the hash 65537
                // times for each guess they make against a password, whereas if the password
                // were hashed only once the attacker would have been able to make 65537 different
                // guesses in the same amount of time instead of only one.
                // for($round = 0; $round < 65536; $round++)
                // {
                //     $password = hash('sha256', $password . $salt);
                // }
                $password = user_hash_password($_POST['password']);
                // Here we prepare our tokens for insertion into the SQL query.  We do not
                // store the original password; only the hashed version of it.  We do store
                // the salt (in its plaintext form; this is not a security risk).
                $query_params = array(
                    ':fullname' => $_POST['fullname'],
                    ':password' => $password,
                    ':country' => $country,
                    ':city' => $city,
                    ':company' => $company,
                    ':telephone' => $telephone,
                    ':user_type' => $user_type,
                    ':email' => $_POST['email'],
                    ':created' => $date_created,
                );
                try
                {
                    // Execute the query to create the user
                    $stmt = $db->prepare($query);
                    $result = $stmt->execute($query_params);
                }
                catch(PDOException $ex)
                {
                    // Note: On a production website, you should not output $ex->getMessage().
                    // It may provide an attacker with helpful information about your code.
        //            die("Failed to run query: " . $ex->getMessage());
        //            $smarty->assign( 'error', 'Failed to run query: ' . $ex->getMessage());
                    $smarty->assign( 'register_error', $GLOBALS['lang']['something_happend']);
                }
            
                if (isset($_POST['noredirect']) && $_POST['noredirect']=='true' ) {

                } else {


                    /* Sent email
                    **************************************************** */
                    $status = @send_email($_POST['email'],'user_registered');

                    if ($status) {
                        
                    } else {
                        // ToDo: No register welcome email
                    };


                    /* Add Activity
                    **************************************************** */
                    //add_activity ('', 'sing_up', '',$_POST['email'],'');

                   // Add activity
                    @add_activity ('user_registered',$_POST['email'], $user_type);


                    // This redirects the user back to the login page after they register
                    // header("Location: /login/?message=successfull&email=".$_POST['email']."");
                    $smarty->assign( 'register_message', $GLOBALS['lang']['registration_sucessfull']);

                    // Calling die or exit after performing a redirect using the header function
                    // is critical.  The rest of your PHP script will continue to execute and
                    // will be sent to the user if you do not die or exit.
        //            die("Redirecting to /login/");
                }
        }
    }

