<?php

use PHPMailer\PHPMailer\PHPMailer;

use PHPMailer\PHPMailer\SMTP;

use PHPMailer\PHPMailer\Exception;

use Twilio\Rest\Client;



require $_SERVER['DOCUMENT_ROOT'].'/_libraries/vendor/autoload.php';



// Use this function fora ny CURL request

function api_curl($resource){

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);

    curl_setopt($curl, CURLOPT_HEADER, false);

    // curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);

    curl_setopt($curl, CURLOPT_URL, $resource);

    // curl_setopt($curl, CURLOPT_REFERER, $resource);

    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

    $output = curl_exec($curl);

    curl_close($curl);

    return $output;

}



function samsara_api($resource) {



    $authorization = "Authorization: Bearer ".$GLOBALS['samsara_token']."";

    $ch = curl_init();



    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json' , $authorization ));

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    curl_setopt($ch, CURLOPT_URL, $resource);

    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");

    // curl_setopt($ch, CURLOPT_POSTFIELDS, $params);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // curl_setopt($ch, CURLOPT_POSTFIELDS,$post);

    // curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);

    $result = curl_exec($ch);

    curl_close($ch);

    return json_decode($result, true);



}





function truckerstreet_get_api($resource) {



    $ch = curl_init();



    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json'));

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

    curl_setopt($ch, CURLOPT_URL, $resource);

    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");

    // curl_setopt($ch, CURLOPT_POSTFIELDS, $params);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // curl_setopt($ch, CURLOPT_POSTFIELDS,$post);

    // curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);

    $result = curl_exec($ch);

    curl_close($ch);

    return json_decode($result, true);



}







function samsara_patch($resource, $body) {



$authorization = "Authorization: Bearer ".$GLOBALS['samsara_token']."";

$ch = curl_init();



curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/json' , $authorization ));

curl_setopt($ch, CURLOPT_URL, $resource);

curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PATCH');

curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

curl_setopt($ch, CURLOPT_POSTFIELDS, $body);

curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);

$result = curl_exec($ch);

curl_close($ch);



return json_decode($result, true);



}









function auth_api_call($resource=NULL,$method=NULL){



   require ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');







    if (strpos($resource,'?') !== false) {

        $resource = $GLOBALS['apiUrl'].$resource.'&'.$GLOBALS['aPiUsrNm'].'='.$GLOBALS['aPiUsrNmVaLue'].'&'.$GLOBALS['aPiPswRd'].'='.$GLOBALS['aPiPswRdVaLue'].'';

    } else {

        $resource = $GLOBALS['apiUrl'].$resource.'?'.$GLOBALS['aPiUsrNm'].'='.$GLOBALS['aPiUsrNmVaLue'].'&'.$GLOBALS['aPiPswRd'].'='.$GLOBALS['aPiPswRdVaLue'].'';

    }

    $resource = str_replace(' ', '%20', $resource);

    // var_dump($resource);

  

    $output = api_curl($resource);

    return json_decode($output,$method);

     

}



function api_call($resource=NULL,$method=NULL,$token=''){





   require ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');







    if (strpos($resource,'?') !== false) {

        $resource = $GLOBALS['apiUrl'].$resource.'&token='.$token.'';

    } else {

        $resource = $GLOBALS['apiUrl'].$resource.'?token='.$token.'';

    }

    

    $output = api_curl($resource);



     //var_dump($resource); 



    return json_decode($output,$method);

     

}





   function date_compare($element1, $element2) { 

    $datetime1 = strtotime($element1['time']); 

    $datetime2 = strtotime($element2['time']); 

    return $datetime1 - $datetime2; 

}  





function get_api_call($resource=NULL,$token='',$method=NULL){



    include_once ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');



    if (strpos($resource,'?') !== false) {

        $resource = $GLOBALS['apiUrl'].$resource.'&token='.$token.'';

    } else {

        $resource = $GLOBALS['apiUrl'].$resource.'?token='.$token.'';

    }

   



    $output = api_curl($resource);



    // var_dump($resource);



    return json_decode($output,$method);

     

}





// APP level of authorisation

// App id / App secret

function app_api_call($resource=NULL,$method=NULL){

   require ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');



    // $subdomain = explode('.', $_SERVER['HTTP_HOST'])[0];

    

    // if (in_array($subdomain, $GLOBALS['instances'])) {

        

    //     require ($_SERVER['DOCUMENT_ROOT'].'/_config/_'.$subdomain.'_config.php');

        



    // } else {

        

    //     // echo "Instance not known!";



    // }





    if (strpos($resource,'?') !== false) {

        $resource = $GLOBALS['apiUrl'].$resource.'&'.$GLOBALS['aPiUsrNm'].'='.$GLOBALS['aPiUsrNmVaLue'].'&'.$GLOBALS['aPiPswRd'].'='.$GLOBALS['aPiPswRdVaLue'];

    } else {

        $resource = $GLOBALS['apiUrl'].$resource.'?'.$GLOBALS['aPiUsrNm'].'='.$GLOBALS['aPiUsrNmVaLue'].'&'.$GLOBALS['aPiPswRd'].'='.$GLOBALS['aPiPswRdVaLue'];

    }

    $resource = str_replace(' ', '%20', $resource);

    // var_dump($resource);



   

    $output = api_curl($resource);



    // if (isset($output) && !empty($output)) { } else { 

    //     @$output = file_get_contents($resource);

    // } 



    return json_decode($output,$method);

     

     

}





function isJSON($string){

   return is_string($string) && is_array(json_decode($string, true)) ? true : false;

}

/*************************

    TOKEN START

*************************/



function setToken($id){

    include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');

    $json='';

    

    $tokenGeneric = $GLOBALS['SECRET_KEY'].$id; // It can be 'stronger' of course

    $token = hash('sha256', $tokenGeneric);

    //the expiration date will be in one hour from the current moment

    $row['tokenExpiration'] = $tokenExpiration = date('Y-m-d H:i:s', strtotime('+1 hour'));

    

    try {

        $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);

        $data = $conn->prepare('

            UPDATE '.$GLOBALS['db_prefix'].'users

            SET token=:token, token_expire=:token_expire    

            WHERE id=:user_id

            ');

        $data->execute(

            array(

                'user_id' => $id,

                'token' => $token,

                'token_expire' => $tokenExpiration,

            )

        );

    } catch(PDOException $e) { return false; }   

    return $token.'.'.$tokenExpiration;

}





function setTokenB0($id){

    include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');

    $json='';

    

    $tokenGeneric = $GLOBALS['SECRET_KEY'].$id; // It can be 'stronger' of course

    $token = hash('sha256', $tokenGeneric);

    //the expiration date will be in one hour from the current moment

    $row['tokenExpiration'] = $tokenExpiration = date('Y-m-d H:i:s', strtotime('+1 hour'));

    

    try {

        $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);

        $data = $conn->prepare('

            UPDATE users

            SET token=:token, token_expire=:token_expire    

            WHERE id=:user_id

            ');

        $data->execute(

            array(

                'user_id' => $id,

                'token' => $token,

                'token_expire' => $tokenExpiration,

            )

        );

    } catch(PDOException $e) { return false; }   

    return $token.'.'.$tokenExpiration;

}







function removeToken($id,$token) {

    include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');

    try {

        $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);

        $data = $conn->prepare('

            UPDATE '.$GLOBALS['db_prefix'].'users

            SET token="",

            token_expire=""    

            WHERE id=:id AND token=:token

            ');

        $data->execute(

            array(

                'id' => $id,

                'token' => $token,

            )

        );

    } catch(PDOException $e) { return false;}   

    return true;

}





function removeTokenB0($id,$token) {

    include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');

    try {

        $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);

        $data = $conn->prepare('

            UPDATE users

            SET token="",

            token_expire=""    

            WHERE id=:id AND token=:token

            ');

        $data->execute(

            array(

                'id' => $id,

                'token' => $token,

            )

        );

    } catch(PDOException $e) { return false;}   

    return true;

}



/*************************

    TOKEN END

*************************/





/* ARRAY SEARCH */

function recursive_array_search($needle,$haystack) {

        foreach($haystack as $key=>$value) {

            $current_key=$key;

            if($needle===$value OR (is_array($value) && recursive_array_search($needle,$value) !== false)) {

                return $current_key;

            }

        }

        return false;

    }

 



function array_sort_by_column( $array, $column, $direction = SORT_DESC) {

    

        $reference_array = array();



        foreach($array as $key => $row) {

            $reference_array[$key] = $row[$column];

        }



        array_multisort($reference_array, $direction, $array);

    }





function getFiles ($folder,$returnNum='false') {

        $dir = $GLOBALS['app_folder_path'].'/'.$folder.'/';

        $path = $GLOBALS['app_folder_path'].'/'.$folder.'/';

        if( @chmod($path, 0777) ) {

            // more code

            @chmod($path, 0755);

        }

        if (file_exists($dir)) {

            if ( $returnNum == 'false') {

                 $filelist = array_diff(scandir($dir,1), array('..', '.', 'thumb','thumb_xs'));

                foreach ($filelist as $key => $link) {

                    if(is_dir($dir.$link)){

                        unset($filelist[$key]);

                    }

                    $filelist[$key] = str_replace(' ', '%20', $link);

                }

                return array_values($filelist);;

            } else {

                if (is_dir_empty($dir)) {

                    return '0';

                } else {

                    return '1';

                }

            }

        } else {

            if ( $returnNum == 'false') {

                return false;

            } else {

                return '0';

            }

        }

    }







function getAllFiles ($folder,$returnNum='false') {

        $dir = $GLOBALS['app_folder_path'].'/'.$folder.'/';

        $path = $GLOBALS['app_folder_path'].'/'.$folder.'/';

        if( @chmod($path, 0777) ) {

            // more code

            @chmod($path, 0755);

        }

        if (file_exists($dir)) {

            if ( $returnNum == 'false') {

                return array_diff(scandir($dir,1), array('..', '.'));

            } else {

                if (is_dir_empty($dir)) {

                    return '0';

                } else {

                    return '1';

                }

            }

        } else {

            if ( $returnNum == 'false') {

                return false;

            } else {

                return '0';

            }

        }

    }





function getAllLoadsFiles ($folder,$returnNum='false') {

        $dir = $GLOBALS['app_folder_path'].'/'.$folder.'/';

        $path = $GLOBALS['app_folder_path'].'/'.$folder.'/';

        if( @chmod($path, 0777) ) {

            // more code

            @chmod($path, 0755);

        }

        if (file_exists($dir)) {

            if ( $returnNum == 'false') {

                return array_values(array_diff(scandir($dir,1), array('..', '.', 'rate-conf', 'bol')));

            } else {

                if (is_dir_empty($dir)) {

                    return '0';

                } else {

                    return '1';

                }

            }

        } else {

            if ( $returnNum == 'false') {

                return false;

            } else {

                return '0';

            }

        }

    }









function zipData($source, $destination) {

            if (extension_loaded('zip')) {

                if (file_exists($source)) {

                    $zip = new ZipArchive();

                    if ($zip->open($destination, ZIPARCHIVE::CREATE | ZipArchive::OVERWRITE)) {

                        $source = realpath($source);

                        if (is_dir($source)) {

                            $iterator = new RecursiveDirectoryIterator($source);

//                            $files = iterator_to_array($iterator, true);

                            // skip dot files while iterating 

                            $iterator->setFlags(RecursiveDirectoryIterator::SKIP_DOTS);

                            $files = new RecursiveIteratorIterator($iterator, RecursiveIteratorIterator::SELF_FIRST);

                            foreach ($files as $file) {

                                $file = realpath($file);

                                if (is_dir($file)) {

                                    $zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));

                                } else if (is_file($file)) {

                                    $zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file));

                                }

                            }

                        } else if (is_file($source)) {

                            $zip->addFromString(basename($source), file_get_contents($source));

                        }

                    }

                    return $zip->close();

                }

            }

            return false;

        }





function get_days($sStartDate=NULL, $sEndDate=NULL, $counter=NULL){

        // Firstly, format the provided dates.

        // This function works best with YYYY-MM-DD

        // but other date formats will work thanks

        // to strtotime().

        $sEndDate = DateTime::createFromFormat('d/m/Y', $sEndDate);

        $sStartDate = DateTime::createFromFormat('d/m/Y', $sStartDate);



        // Start the variable off with the start date

        $aDays[] = $sStartDate->format('Y-m-d');



        // Set a 'temp' variable, sCurrentDate, with

        // the start date - before beginning the loop

        $sCurrentDate = $sStartDate->format('Y-m-d');



        // While the current date is less than the end date

        while($sCurrentDate < $sEndDate->format('Y-m-d')){

            // Add a day to the current date

            $sCurrentDate = date("Y-m-d", strtotime("+1 day", strtotime($sCurrentDate)));



            // Add this new day to the aDays array

            $aDays[] = date("d/m/Y", strtotime($sCurrentDate));

        }



        // Once the loop has finished, return the

        // array of days.

        return $aDays;



    }



function get_days_us($sStartDate=NULL, $sEndDate=NULL, $counter=NULL){

        // Firstly, format the provided dates.

        // This function works best with YYYY-MM-DD

        // but other date formats will work thanks

        // to strtotime().

        $sEndDate = DateTime::createFromFormat('Y-m-d', $sEndDate);

        $sStartDate = DateTime::createFromFormat('Y-m-d', $sStartDate);



        // Start the variable off with the start date

        $aDays[] = $sStartDate->format('Y-m-d');



        // Set a 'temp' variable, sCurrentDate, with

        // the start date - before beginning the loop

        $sCurrentDate = $sStartDate->format('Y-m-d');



        // While the current date is less than the end date

        while($sCurrentDate < $sEndDate->format('Y-m-d')){

            // Add a day to the current date

            $sCurrentDate = date("Y-m-d", strtotime("+1 day", strtotime($sCurrentDate)));



            // Add this new day to the aDays array

            $aDays[] = date("Y-m-d", strtotime($sCurrentDate));

        }



        // Once the loop has finished, return the

        // array of days.

        return $aDays;



    }



function days_between ($start=NULL, $end=NULL) {

        $start = strtotime($start);

        $end = strtotime($end);

        $datediff = $end - $start;

        return floor($datediff/(60*60*24));

    }





function get_secured_password($password) {



        // A salt is randomly generated here to protect again brute force attacks

        // and rainbow table attacks.  The following statement generates a hex

        // representation of an 8 byte salt.  Representing this in hex provides

        // no additional security, but makes it easier for humans to read.

        // For more information:

        // http://en.wikipedia.org/wiki/Salt_%28cryptography%29

        // http://en.wikipedia.org/wiki/Brute-force_attack

        // http://en.wikipedia.org/wiki/Rainbow_table

        $salt = dechex(mt_rand(0, 2147483647)) . dechex(mt_rand(0, 2147483647));



        // This hashes the password with the salt so that it can be stored securely

        // in your database.  The output of this next statement is a 64 byte hex

        // string representing the 32 byte sha256 hash of the password.  The original

        // password cannot be recovered from the hash.  For more information:

        // http://en.wikipedia.org/wiki/Cryptographic_hash_function

        $password = hash('sha256', $password . $salt);



        // Next we hash the hash value 65536 more times.  The purpose of this is to

        // protect against brute force attacks.  Now an attacker must compute the hash 65537

        // times for each guess they make against a password, whereas if the password

        // were hashed only once the attacker would have been able to make 65537 different

        // guesses in the same amount of time instead of only one.

        for($round = 0; $round < 65536; $round++)

        {

             $password = hash('sha256', $password . $salt);

        }

        return $password.'::'.$salt;

}



function slugify($text)

            {

            $newtext = $text;



            $text = str_replace('š', 's', $text);

            $text = str_replace('č', 'c', $text);

            $text = str_replace('ć', 'c', $text);

            $text = str_replace('đ', 'dj', $text);

            $text = str_replace('ž', 'z', $text);



              // replace non letter or digits by -

              $text = preg_replace('~[^\pL\d]+~u', '-', $text);



              // transliterate

              $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);



              // remove unwanted characters

              $text = preg_replace('~[^-\w]+~', '', $text);



              // trim

              $text = trim($text, '-');



              // remove duplicate -

              $text = preg_replace('~-+~', '-', $text);



              // lowercase

              $text = strtolower($text);



              if (empty($text)) {



                $newtext = strtolower(trim(preg_replace('/[^a-zA-Z0-9]+/', '-', $newtext), '-'));

                $newtext = strtolower(trim($newtext, '-'));

                $newtext = preg_replace("/[\/_|+ -]+/", '-', $newtext);



                return $newtext;

              }



              return $text;

            }



function is_bot()

            {

                /* This function will check whether the visitor is a search engine robot */



                $botlist = array("Teoma", "alexa", "froogle", "Gigabot", "inktomi",

                "looksmart", "URL_Spider_SQL", "Firefly", "NationalDirectory",

                "Ask Jeeves", "TECNOSEEK", "InfoSeek", "WebFindBot", "girafabot",

                "crawler", "www.galaxy.com", "Googlebot", "Scooter", "Slurp",

                "msnbot", "appie", "FAST", "WebBug", "Spade", "ZyBorg", "rabaz",

                "Baiduspider", "Feedfetcher-Google", "TechnoratiSnoop", "Rankivabot",

                "Mediapartners-Google", "Sogou web spider", "WebAlta Crawler","TweetmemeBot",

                "Butterfly","Twitturls","Me.dium","Twiceler");



                foreach($botlist as $bot)

                {

                    if(strpos($_SERVER['HTTP_USER_AGENT'],$bot)!==false)

                    return true;    // Is a bot

                }



                return false;    // Not a bot

            }



function extractCommonWords($string){

      $stopWords = array('i','a','about','an','and','are','as','at','be','by','com','de','en','for','from','how','in','is','it','la','of','on','or','that','the','this','to','was','what','when','where','who','will','with','und','the','www');

   

      $string = preg_replace('/\s\s+/i', '', $string); // replace whitespace

      $string = trim($string); // trim the string

      $string = preg_replace('/[^a-zA-Z0-9 -]/', '', $string); // only take alphanumerical characters, but keep the spaces and dashes too…

      $string = strtolower($string); // make it lowercase

   

      preg_match_all('/\b.*?\b/i', $string, $matchWords);

      $matchWords = $matchWords[0];

      

      foreach ( $matchWords as $key=>$item ) {

          if ( $item == '' || in_array(strtolower($item), $stopWords) || strlen($item) <= 3 ) {

              unset($matchWords[$key]);

          }

      }   

      $wordCountArr = array();

      if ( is_array($matchWords) ) {

          foreach ( $matchWords as $key => $val ) {

              $val = strtolower($val);

              if ( isset($wordCountArr[$val]) ) {

                  $wordCountArr[$val]++;

              } else {

                  $wordCountArr[$val] = 1;

              }

          }

      }

      arsort($wordCountArr);

      $wordCountArr = array_slice($wordCountArr, 0, 10);

      return $wordCountArr;

}



function StringInputCleaner($data)

            {

                //remove space bfore and after

                $data = trim($data);

                //remove slashes

                $data = stripslashes($data);

                $data=(filter_var($data, FILTER_SANITIZE_STRING));

                return $data;

            }









function mysqlCleaner($data)

            {

                $data= mysqli_real_escape_string($data);

                $data= stripslashes($data);

                return $data;

                //or in one line code

                //return(stripslashes(mysql_real_escape_string($data)));

            }







function get_random_string($length=15,$characters = "ABCDEFGHIJKLMNOPRQSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789") {

                    $num_characters = strlen($characters) - 1;

                    $return='';

                    while (strlen($return) < $length) {

                        $return.= $characters[mt_rand(0, $num_characters)];

                    }

                    return $return;

            }





function get_random_numbers($length=6,$characters = "0123456789") {

                    $num_characters = strlen($characters) - 1;

                    $return='';

                    while (strlen($return) < $length) {

                        $return.= $characters[mt_rand(0, $num_characters)];

                    }

                    return $return;

            }







 

function getClientIP() {



            if (isset($_SERVER)) {



                if (isset($_SERVER["HTTP_X_FORWARDED_FOR"]))

                    return $_SERVER["HTTP_X_FORWARDED_FOR"];



                if (isset($_SERVER["HTTP_CLIENT_IP"]))

                    return $_SERVER["HTTP_CLIENT_IP"];



                return $_SERVER["REMOTE_ADDR"];

            }



            if (getenv('HTTP_X_FORWARDED_FOR'))

                return getenv('HTTP_X_FORWARDED_FOR');



            if (getenv('HTTP_CLIENT_IP'))

                return getenv('HTTP_CLIENT_IP');



            return getenv('REMOTE_ADDR');

        }











function createThumbnail($filename, $final_width_of_image, $path_to_image_directory, $path_to_thumbs_directory) {





            if(preg_match('/[.](jpg)$/', $filename)) {

                $im = imagecreatefromjpeg($path_to_image_directory . $filename);

            } else if (preg_match('/[.](gif)$/', $filename)) {

                $im = imagecreatefromgif($path_to_image_directory . $filename);

            } else if (preg_match('/[.](png)$/', $filename)) {

                $im = imagecreatefrompng($path_to_image_directory . $filename);

            }



            $ox = imagesx($im);

            $oy = imagesy($im);



            $nx = $final_width_of_image;

            $ny = floor($oy * ($final_width_of_image / $ox));



            $nm = imagecreatetruecolor($nx, $ny);



            imagecopyresized($nm, $im, 0,0,0,0,$nx,$ny,$ox,$oy);



            if(!file_exists($path_to_thumbs_directory)) {

              if(!mkdir($path_to_thumbs_directory)) {

                   die("There was a problem. Please try again!");

              }

               }



            imagejpeg($nm, $path_to_thumbs_directory . $filename);

            /* $tn = '<img src="' . $path_to_thumbs_directory . $filename . '" alt="image" />';

            $tn .= '<br />Congratulations. Your file has been successfully uploaded, and a      thumbnail has been created.';

            echo $tn; */

        }



function make_thumb($src, $dest, $desired_width) {

    // https://davidwalsh.name/create-image-thumbnail-php



    /* read the source image */

    $source_image = imagecreatefromjpeg($src);

    $width = imagesx($source_image);

    $height = imagesy($source_image);

    

    /* find the "desired height" of this thumbnail, relative to the desired width  */

    $desired_height = floor($height * ($desired_width / $width));

    

    /* create a new, "virtual" image */

    $virtual_image = imagecreatetruecolor($desired_width, $desired_height);

    

    /* copy source image at a resized size */

    imagecopyresampled($virtual_image, $source_image, 0, 0, 0, 0, $desired_width, $desired_height, $width, $height);

    

    /* create the physical thumbnail image to its destination */

    imagejpeg($virtual_image, $dest);

}





function isWeekend() {

            $date = date("l");

            if($date == "Saturday" || $date == "Sunday"){

                return "true";

            } else {

                return "false";

            }

        }







function getStaticServer ($i) {



            // Static Img Servers

            $staticIMGServer0='';

            $staticIMGServer1='';

            $staticIMGServer2='';



            // Static Server Change

            $staticIMGServer = '';

            if ($i<=10) {$staticIMGServer = $staticIMGServer1;}

                else if ($i>10 and $i<=20) {$staticIMGServer = $staticIMGServer2;}

                    else if ($i>20 and $i<=30) {$staticIMGServer = $staticIMGServer1;}

                        else {$staticIMGServer = $staticIMGServer0;}





            return $staticIMGServer;

        }









function generateScript($proj_code) {

                    return '<script src="http://demo.vlogr.it/track.js?c='.$proj_code.'"></script>';

                    //return '<script src="http://demo.vlogr.it/track.js?c='.$proj_code.'"></script>';

        }







function set_project_domain_cookie() {

            try {

                $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);

                $data = $conn->prepare('

                    SELECT proj_code, server

                    FROM '.$GLOBALS['db_prefix'].'roles

                    WHERE user_id=:user_id

                ');

                $data->execute(array('user_id'=>$_SESSION['user']['id']));

                $result = $data->fetchAll();

                if ( count($result) ) {

                    foreach($result as $row) {



                        setcookie($row['proj_code'], $row['server'], time() + (86400 * 30), "/");



                    }

                }

            } catch(PDOException $e) { $json[] = array('error'=>$e->getMessage()); }

        }







function is_dir_empty($dir) {

          if (!is_readable($dir)) return NULL;

          return (count(scandir($dir)) == 2);

        }





/* Clean cache

**************************************************** */

function removeDirectory($path) {

            if (is_dir_empty($path)) {

                return false;

            } else {

                $files = @glob($path . '/*');

                if (isset($files) && count($files)>0 && is_array($files)) {

                    foreach ($files as $file) {

                        @is_dir($file) ? removeDirectory($file) : @unlink($file);

                    }

                }

                @rmdir($path);

                return;

            }

        }





function clearCache () {



            $dir = $_SERVER['DOCUMENT_ROOT'].'/admin/_cache/';

            removeDirectory($dir);

            $dir = $_SERVER['DOCUMENT_ROOT'].'/api/_cache/';

            removeDirectory($dir);

            $dir = $_SERVER['DOCUMENT_ROOT'].'/app/_cache/';

            removeDirectory($dir);

            $dir = $_SERVER['DOCUMENT_ROOT'].'/www/_cache/';

            removeDirectory($dir);

    

            $dir = $_SERVER['DOCUMENT_ROOT'].'/admin/templates_c/';

            removeDirectory($dir);

        }



function clearUserCache ($idDir=NULL) {



            $dir = $_SERVER["DOCUMENT_ROOT"].'/api/_cache/'.$idDir.'/';

            removeDirectory($dir);

            //$dir = $_SERVER["DOCUMENT_ROOT"].'/www/_cache/';

            //removeDirectory($dir);

            $dir = $_SERVER["DOCUMENT_ROOT"].'/admin/_cache/'.$idDir.'/';

            removeDirectory($dir);

        }



function clear_api_cache () {



            $dir = $_SERVER["DOCUMENT_ROOT"].'/api/_cache/';

            removeDirectory($dir);

        }





function clear_www_cache () {



            $dir = $_SERVER["DOCUMENT_ROOT"].'/www/_cache/';

            removeDirectory($dir);

        }





function clear_admin_cache () {



            $dir = $_SERVER["DOCUMENT_ROOT"].'/admin/_cache/';

            removeDirectory($dir);

        }



function clear_cache($resource, $val) {



        $dir = $_SERVER['DOCUMENT_ROOT'].'/api/_cache/';





        if (file_exists($dir)) {

            

            $files = scandir($dir);



            foreach ($files as $file) {

                if (strpos($file, $val) !== false) {



                $file = urldecode($file);

                unlink($dir.$file);

              

              }

            }

            

        }





}







/* -------------------------------------------------*/

/*                    USERS                         */

/* -------------------------------------------------*/







function get_user_id (){

            include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');

            $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);

        // Get user id

            $data = $conn->prepare('SELECT * FROM '.$GLOBALS['db_prefix'].'users WHERE user_name= :user_name LIMIT 1 ');

            $data->execute(array('user_name' => $_SESSION['user']['username']));

            $result = $data->fetchAll();

            if ( count($result) ) {

                $_SESSION['user']['id']=  $result['user_id'];

                $tpl->assign( 'UserID', $_SESSION['user']['id']);

            }

        }





function get_user_id_by_email ($user_email){

                include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');

                $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);

        // Get user id

                $data = $conn->prepare('SELECT user_id FROM '.$GLOBALS['db_prefix'].'users WHERE user_email= :user_email LIMIT 1 ');

                $data->execute(array('user_email' => $user_email));

                $result = $data->fetchAll();

                if ( count($result) ) {

                    return  $result['user_email'];

                }

        }







function get_role_text ($id) {



            switch($id) {



                case '0':

                    return 'Admin';

                    break;



                case '1':

                    return 'Editor';

                    break;



                case '2':

                    return 'Viewer';

                    break;



            }

        }







/* -------------------------------------------------*/

/*                    USER ROLE                     */

/* -------------------------------------------------*/



    function add_user_role ($user_id, $proj_code, $user_role) {

        include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');

        $conn = new PDO("mysql:host=".$GLOBALS[$_COOKIE[$proj_code]]['db_host'].";dbname=".$GLOBALS[$_COOKIE[$proj_code]]['db_database'], $GLOBALS[$_COOKIE[$proj_code]]['db_user'], $GLOBALS[$_COOKIE[$proj_code]]['db_pass']);

        // Check if notice already exist

        try {

            $data = $conn->prepare('INSERT INTO '.$GLOBALS['db_prefix'].'roles (user_id, proj_code, user_role, date_created) VALUES (:user_id, :proj_code, :user_role, :date)');

            $data->execute(

                array(

                    'user_id' => $user_id,

                    'proj_code' => $proj_code,

                    'user_role' => $user_role,

                    'date' => $GLOBALS['current_date']

                    )

            );

        }

        catch (Exception $e){throw new Exception( $global_error_message, 0, $e);}

    }







/* -------------------------------------------------*/

/*                    NOTICE                        */

/* -------------------------------------------------*/

  



/* -------------------------------------------------*/

/*                    ACTIVITY                      */

/* -------------------------------------------------*/



/* Project code, Activity Action, User, Extra activity, Server



act_action =

    

    add_domain

    edit_domain

    delete_domain

    

    add_project

    edit_project

    delete_project

    activate_project

    archive_project

    add_notice

    update_notice



    update_profile

    

    people_add

    people_invite

    

    sing_up

    

*/    function add_activity ( $act_action=NULL, $act_user=NULL, $act_extra=NULL, $act_extra2=NULL ) {

        include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');

        try {

             

            /* Connection

            **************************************************** */

            $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);

            $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            $conn->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

            $conn->exec("set names utf8");

             

            $data = $conn->prepare('

                INSERT INTO '.$GLOBALS['db_prefix'].'activities 

                (act_action, act_user, act_extra, act_extra2, date_time) 

                VALUES (:act_action, :act_user, :act_extra,:act_extra2, :date_time)

            ');

            $data->execute(array(

                'act_action' => $act_action,

                'act_user' => $act_user,

                'act_extra' => $act_extra,

                'act_extra2' => $act_extra2,

                'date_time' => $GLOBALS['current_date_time'])

            );

        } catch(PDOException $e) { $errors[] = $e->getMessage(); }

    }







function add_notification ( $action_by=NULL, $notif_type=NULL, $action=NULL, $object=NULL, $lead_id=NULL, $instance=NULL) {



    include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');



    try {

         

        /* Connection

        **************************************************** */

        $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_recruiting_database'], $GLOBALS['db_recruiting_user'], $GLOBALS['db_recruiting_pass']);

        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $conn->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

        $conn->exec("set names utf8");

         

        $data = $conn->prepare('

            INSERT INTO '.$GLOBALS['db_prefix'].'notifications 

            (action_by, notif_type, action, object, lead_id, date_time) 

            VALUES (:action_by, :notif_type, :action, :object, :lead_id, :date_time)

        ');

        $data->execute(array(

            'action_by' => $action_by,

            'notif_type' => $notif_type,

            'action' => $action,

            'object' => $object,

            'lead_id' => $lead_id,

            'date_time' => $GLOBALS['current_date_time'])

        );

    } catch(PDOException $e) { $errors[] = $e->getMessage(); }

}











function activity_text($act_action, $act_user, $act_extra) {

        switch($act_action) {



            case 'add_domain':

                return '<span style="font-weight:500;">'.$act_user.'</span> added a new domain "'.$act_extra.'".';

                break;



            case 'edit_domain':

                return '<span style="font-weight:500;">'.$act_user.'</span> edited a domain security to "'.get_domain_status_text($act_extra).'".';

                break;



            case 'update_notice':

                return '<span style="font-weight:500;">'.$act_user.'</span> updated a notice text to "'.$act_extra.'".';

                break;



            case 'add_project':

                return '<span style="font-weight:500;">'.$act_user.'</span> added a new project "'.$act_extra.'".';

                break;



        }

}









function activity_icon ($act_action) {



            switch($act_action) {



                case 'add_domain':

                    return 'info';

                    break;



                case 'edit_domain':

                    return 'info';

                    break;



                case 'update_notice':

                    return 'info';

                    break;



                case 'add_project':

                    return 'info';

                    break;





            }

}





 





/* -------------------------------------------------*/

/*                    Log                             */

/* -------------------------------------------------*/







function send_email_log ($s=NULL,$m=NULL) {

//    $to      = 'log@vlogr.it';

//    $subject = $s;

//    $message = $m;

//    $headers = 'From: log@vlogr.it' . "\r\n" .

//    'X-Mailer: PHP/' . phpversion();

//

//    mail($to, $subject, $message, $headers);



}





function send_email ($to=NULL,$type=NULL,$from='ivan@42nmarketing.com',$cc=NULL,$extra=NULL,$extra2=NULL,$extra3=NULL,$extra4=NULL,$extra5=NULL,$extra6=NULL,$extra7=NULL,$extra8=NULL) {

    include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');



    switch ($type) {

   

        //------------------

            

        case 'bf':

            $subject = 'New message from Eagle';

            $title = 'New message from Eagle (Bugs and Features)';

            $message_html = 'Email:'.$extra.'<br>'  ;

            $message_html .= 'Description:'.$extra2.'<br>'  ;

        break;





        case 'forward':

            $subject = 'New Forward';

            $title = 'New Forward';

            $message_html = 'New Forward';

        break;





        case 'reset-password':

            $subject = 'Your password has been reset.';

            $title = 'Your password has been reset.';

            $message_html = '<table width="600px" style="font-family:Arial">

        <thead>

            <tr>

                <th style="text-align:left;background:#f2f2f2;padding:15px;border-bottom:4px double #ccc"><img src="https://cdn.eaglerecruiting.xyz/adm/assets/img/logo-rms.png" alt="Eagle RMS"></th>

            </tr>

        </thead>

        <tbody>

            <tr>

                <td>

                    <p style="color:#00b894;font-weight:700;font-size:13px">Your password has been reset.<br>The new temporary password is <span style="background:#00b894;color:#fff;text-decoration:none;padding:3px 10px;border-radius:3px;font-weight:700">'.$extra.'</span></p>

                    </td>

            </tr>

            <tr>

                <td>

                    <p style="margin:0 0 40px 0;font-size:14px;line-height:1.7;color:#666;letter-spacing:0.5px">Please, login and change the temporary password.</p>

                </td>

            </tr>

        </tbody>

        <tfoot>

            <tr>

                <td style="text-align:left;background:#f2f2f2;padding:20px 15px;color:#0984e3;font-size:12px;border-top:4px double #ccc"><a href="mailto:admin@eaglerms.com" target="_blank">admin@eaglerms.com</a></td>

            </tr>

        </tfoot>

    </table>';

        break;





        case 'new-lead':

            $subject = 'New Lead on Eagle - ['.$extra4.']';

            $title = 'New Lead on Eagle';



            $message_html = '<table width="600px" style="font-family:Arial">

        <thead>

            <tr>

                <th style="text-align:left;background:#f2f2f2;padding:15px;border-bottom:4px double #ccc"><img src="https://cdn.eaglerecruiting.xyz/adm/assets/img/logo-rms.png" alt="Eagle RMS"></th>

            </tr>

        </thead>

        <tbody>

            <tr>

                <td>

                    <p style="color:#00b894;font-weight:700;font-size:13px">You have a new application for job.</p>

                    <p style="font-weight:700;font-size:20px;margin:40px 0 20px 0">Personal information</p></td>

            </tr>

            <tr>

                <td><p style="margin:0 0 40px 0;font-size:14px;line-height:1.7;color:#666;letter-spacing:0.5px">UID: <span style="background:#666;color:#fff;border-radius:3px;padding:3px 10px">'.$extra.'</span><br>First Name: '.$extra2.'<br>Last Name: '.$extra3.'<br>Instance: '.$extra4.'<br>Link: <a href="https://www.eaglerecruiting.xyz/en/'.$extra4.'-apply/?uid='.$extra.'" style="background:#00b894;color:#fff;text-decoration:none;padding:3px 10px;border-radius:3px;font-weight:700">Application link</a></p></td>

            </tr>

        </tbody>

        <tfoot>

            <tr>

                <td style="text-align:left;background:#f2f2f2;padding:20px 15px;color:#0984e3;font-size:12px;border-top:4px double #ccc"><a href="mailto:admin@eaglerms.com" target="_blank">admin@eaglerms.com</a></td>

            </tr>

        </tfoot>

    </table>';

        break;

        



        

    }



    $mail = new PHPMailer(true);



    try {

        //Server settings

        // $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      //Enable verbose debug output

        $mail->isSMTP();                                            //Send using SMTP

         $mail->SMTPOptions = array(

            'ssl' => array(

                'verify_peer' => false,

                'verify_peer_name' => false,

                'allow_self_signed' => true

            )

        );

        $mail->Host = $GLOBALS['smtp_host'];                     //Set the SMTP server to send through

        $mail->SMTPAuth   = true;                                   //Enable SMTP authentication

        $mail->Username = $GLOBALS['smtp_username'];                     //SMTP username

        $mail->Password = $GLOBALS['smtp_password'];                               //SMTP password

        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;         //Enable TLS encryption; `PHPMailer::ENCRYPTION_SMTPS` encouraged

        $mail->Port = $GLOBALS['smtp_port'];                                    //TCP port to connect to, use 465 for `PHPMailer::ENCRYPTION_SMTPS` above



        //Recipients

        $mail->setFrom($from, 'Eagle Admin');

        $mail->addAddress($to, 'Eagle Admin');     //Add a recipient



        if($cc) {

            $mail->addAddress($cc, 'Eagle Admin');     //Add a recipient

        }



        //Content

        $mail->isHTML(true);                                  //Set email format to HTML

        $mail->Subject = $subject;

        $mail->Body    = $message_html;



        $mail->send();

        return true;



    } catch (Exception $e) {

        echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";

    }

    



}



function getExcerpt($str, $startPos=0, $maxLength=100) {

    if(strlen($str) > $maxLength) {

        $excerpt   = substr($str, $startPos, $maxLength-3);

        $lastSpace = strrpos($excerpt, ' ');

        $excerpt   = substr($excerpt, 0, $lastSpace);

        $excerpt  .= '...';

    } else {

        $excerpt = $str;

    }

    

    return $excerpt;

}

 function timeAgo( $date) 

{ 

    // for using it with preceding 'vor'            index 

      $timeStrings = array(   'recently',            // 0       <- now or future posts :-) 

                        'second', 'seconds',    // 1,1 

                        'minute','minutes',      // 3,3 

                        'hour', 'hours',   // 5,5 

                        'day', 'days',         // 7,7 

                        'week', 'weeks',      // 9,9 

                        'month', 'months',      // 11,12 

                        'year','years');      // 13,14 

      $debug = false; 

      $sec = time() - (( strtotime($date)) ? strtotime($date) : $date); 

       

      if ( $sec <= 0) return $timeStrings[0]; 

       

      if ( $sec < 2) return $sec." ".$timeStrings[1]; 

      if ( $sec < 60) return $sec." ".$timeStrings[2]; 

       

      $min = $sec / 60; 

      if ( floor($min+0.5) < 2) return floor($min+0.5)." ".$timeStrings[3]; 

      if ( $min < 60) return floor($min+0.5)." ".$timeStrings[4]; 

       

      $hrs = $min / 60; 

      echo ($debug == true) ? "hours: ".floor($hrs+0.5)."<br />" : ''; 

      if ( floor($hrs+0.5) < 2) return floor($hrs+0.5)." ".$timeStrings[5]; 

      if ( $hrs < 24) return floor($hrs+0.5)." ".$timeStrings[6]; 

       

      $days = $hrs / 24; 

      echo ($debug == true) ? "days: ".floor($days+0.5)."<br />" : ''; 

      if ( floor($days+0.5) < 2) return floor($days+0.5)." ".$timeStrings[7]; 

      if ( $days < 7) return floor($days+0.5)." ".$timeStrings[8]; 

       

      $weeks = $days / 7; 

      echo ($debug == true) ? "weeks: ".floor($weeks+0.5)."<br />" : ''; 

      if ( floor($weeks+0.5) < 2) return floor($weeks+0.5)." ".$timeStrings[9]; 

      if ( $weeks < 4) return floor($weeks+0.5)." ".$timeStrings[10]; 

       

      $months = $weeks / 4; 

      if ( floor($months+0.5) < 2) return floor($months+0.5)." ".$timeStrings[11]; 

      if ( $months < 12) return floor($months+0.5)." ".$timeStrings[12]; 

       

      $years = $weeks / 51; 

      if ( floor($years+0.5) < 2) return floor($years+0.5)." ".$timeStrings[13]; 

      return floor($years+0.5)." ".$timeStrings[14]; 

} 

 



/* -------------------------------------------------*/

/*                    Profiles                      */

/* -------------------------------------------------*/



/**

 * Get either a Gravatar URL or complete image tag for a specified email address.

 *

 * @param string $email The email address

 * @param string $s Size in pixels, defaults to 80px [ 1 - 2048 ]

 * @param string $d Default imageset to use [ 404 | mm | identicon | monsterid | wavatar ]

 * @param string $r Maximum rating (inclusive) [ g | pg | r | x ]

 * @param boole $img True to return a complete IMG tag False for just the URL

 * @param array $atts Optional, additional key/value attributes to include in the IMG tag

 * @return String containing either just a URL or a complete image tag

 * @source http://gravatar.com/site/implement/images/php/

 */

function get_gravatar( $email, $s = 80, $d = 'mm', $r = 'g', $img = false, $atts = array() ) {

    $url = 'http://www.gravatar.com/avatar/';

    $url .= md5( strtolower( trim( $email ) ) );

    $url .= "?s=$s&d=$d&r=$r";

    if ( $img ) {

        $url = '<img src="' . $url . '"';

        foreach ( $atts as $key => $val )

            $url .= ' ' . $key . '="' . $val . '"';

        $url .= ' />';

    }

    return $url;

}



  function fixsql($query) {



        $pattern = '/\s+/S';

        $query = preg_replace( $pattern, ' ',$query);



        $query = str_replace('( )', '', $query);

        $query = str_replace('  ', ' ', $query); 

        $query = str_replace('   ', ' ', $query); 

        $query = str_replace('    ', ' ', $query); 

        $query = str_replace('     ', ' ', $query); 

        $query = str_replace('  ', ' ', $query);

        $query = str_replace('WHERE AND', 'WHERE', $query);

        $query = str_replace('WHERE )', ')', $query);

        $query = str_replace('AND AND', 'AND', $query);

        $query = str_replace('WHERE ;', '', $query);

        $query = str_replace('WHERE LIMIT', 'LIMIT', $query);

        $query = str_replace('WHERE ORDER', 'ORDER', $query);

        $query = str_replace('WHERE GROUP', 'GROUP', $query);

        $query = str_replace('WHERE OR', 'WHERE ', $query);

        $query = str_replace('WHERE ;', ';', $query);

        $query = str_replace('WHERE;', ';', $query);

        $query = str_replace('OR )', ')', $query);

        $query = str_replace('AND )', ')', $query);

        return $query;

    }



    function slackMessage($username,$message,$emoji)

    {

        // Create a constant to store your Slack URL

          define('SLACK_WEBHOOK', 'https://hooks.slack.com/services/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');

          // Make your message

          $message = array('payload' => json_encode(array('text' => $message, 'username' => $username, 'icon_emoji' => $emoji)));

          // Use curl to send your message

          $c = curl_init(SLACK_WEBHOOK);

          curl_setopt($c, CURLOPT_SSL_VERIFYPEER, false);

          curl_setopt($c, CURLOPT_POST, true);

          curl_setopt($c, CURLOPT_POSTFIELDS, $message);

          curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);

          curl_exec($c);

          curl_close($c);

    }





 function get_uid() {

    return sprintf( '%04x%04x-%04x-%04x-%04x-%04x%04x%04x',

        // 32 bits for "time_low"

        mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ),



        // 16 bits for "time_mid"

        mt_rand( 0, 0xffff ),



        // 16 bits for "time_hi_and_version",

        // four most significant bits holds version number 4

        mt_rand( 0, 0x0fff ) | 0x4000,



        // 16 bits, 8 bits for "clk_seq_hi_res",

        // 8 bits for "clk_seq_low",

        // two most significant bits holds zero and one for variant DCE1.1

        mt_rand( 0, 0x3fff ) | 0x8000,



        // 48 bits for "node"

        mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff ), mt_rand( 0, 0xffff )

    );

}







function get_coordinates($city=NULL, $street=NULL, $province=NULL)

{

    $address = urlencode($city.','.$street.','.$province);

    $url = "https://maps.google.com/maps/api/geocode/json?address=$address&sensor=false&region=us&key=".$GLOBALS['google_maps_api']."";

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

    curl_setopt($ch, CURLOPT_PROXYPORT, 3128);

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $response = curl_exec($ch);

    curl_close($ch);

    $response_a = json_decode($response);

    $status = $response_a->status;



    if ( $status == 'ZERO_RESULTS' )

    {

        return FALSE;

    }

    else

    {

        $return = array('lat' => $response_a->results[0]->geometry->location->lat, 'long' => $long = $response_a->results[0]->geometry->location->lng);

        return $return;

    }

}





function get_coordinates_trimble($city=NULL, $street=NULL, $province=NULL, $country=NULL)

{

    $url = "https://pcmiler.alk.com/apis/rest/v1.0/Service.svc/locations?street=".$street."&city=".$city."&state=".$province."&country=".$country."&dataset=Current&authToken=9150AB6F6F559E43BAFC5532CFD7E489";

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

    curl_setopt($ch, CURLOPT_PROXYPORT, 3128);

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $response = curl_exec($ch);

    curl_close($ch);

    $response = json_decode($response, true);

    

    

    return $response;

    

}







function GetDrivingDistanceGoogle($lat1, $lat2, $long1, $long2)

{

    $url = "https://maps.googleapis.com/maps/api/distancematrix/json?origins=".$lat1.",".$long1."&destinations=".$lat2.",".$long2."&mode=driving&units=imperial&language=en-US&key=".$GLOBALS['google_maps_api']."";

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

    curl_setopt($ch, CURLOPT_PROXYPORT, 3128);

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $response = curl_exec($ch);

    curl_close($ch);

    $response_a = json_decode($response, true);

    $dist = $response_a['rows'][0]['elements'][0]['distance']['text'];

    $time = $response_a['rows'][0]['elements'][0]['duration']['text'];



    return array('distance' => $dist, 'time' => $time);

}



function GetDrivingDistanceTrimble($lat1, $lat2, $long1, $long2)

{

    $params = "".$long1.",".$lat1.";".$long2.",".$lat2."";

    $params = urlencode($params);

    $url = "https://pcmiler.alk.com/apis/rest/v1.0/Service.svc/route/routeReports?stops=".$params."&vehType=Truck&reports=Mileage&authToken=9150AB6F6F559E43BAFC5532CFD7E489";

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);

    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

    curl_setopt($ch, CURLOPT_PROXYPORT, 3128);

    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);

    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);

    $response = curl_exec($ch);

    curl_close($ch);

    $response = json_decode($response, true);



    // echo $url;

    return $response;   

}









function rrmdir($dir) { 

$handle = opendir($dir);

if (is_dir($dir)) { 

 $objects = scandir($dir);

 foreach ($objects as $object) { 

   if ($object != "." && $object != "..") { 

     if (is_dir($dir. DIRECTORY_SEPARATOR .$object) && !is_link($dir."/".$object))

       rrmdir($dir. DIRECTORY_SEPARATOR .$object);

     else

       unlink($dir. DIRECTORY_SEPARATOR .$object); 

   } 

 }



 closedir($handle);

 rmdir($dir); 

} 

}





function formatPhone($phone) {



$phone = str_replace('(', '', $phone);

$phone = str_replace(')', '', $phone);

$phone = str_replace('-', '', $phone);

$phone = str_replace(' ', '', $phone);

$phone = str_replace('+1', '', $phone);

$phone = str_replace('.', '', $phone);

$phone = str_replace(',', '', $phone);

$phone = str_replace('p:', '', $phone);

$phone = str_replace('mobile', '', $phone);

$phone = ltrim($phone, '1');



$phone = '+1'.$phone;



return $phone;

}





function sendSMS($to, $body, $sid, $token, $number) {

    

    // Your Account SID and Auth Token from twilio.com/console

    if ($token==NULL) {

        $token = $GLOBALS['twilio-auth'];

    } 



    if ($sid==NULL) {

        $sid = $GLOBALS['twilio-sid'];

    }



    if ($number==NULL) {

        $number = $GLOBALS['twilio-number'];

    }

    



    $client = new Client($sid, $token);

    $client->messages->create(

        // Where to send a text message (your cell phone?)

        $to,

        array(

            'from' => $number,

            'body' => $body

        )

    );

}





function getDaysBetweenTwoDates($date1,$date2){

 $date1 = date('y-m-d',strtotime($date1));

 $date2 = date('y-m-d',strtotime($date2));

 $now = new DateTime($date1);

 $ago = new DateTime($date2);

 $diff = $now->diff($ago);

 return $diff->days;

}


function getStateFromPhone($phone_e164){

$areacode = substr($phone_e164, 2, 3);

$area_codes['201'] = 'NJ';
$area_codes['202'] = 'DC';
$area_codes['203'] = 'CT';
$area_codes['204'] = 'MB';
$area_codes['205'] = 'AL';
$area_codes['206'] = 'WA';
$area_codes['207'] = 'ME';
$area_codes['208'] = 'ID';
$area_codes['209'] = 'CA';
$area_codes['210'] = 'TX';
$area_codes['212'] = 'NY';
$area_codes['213'] = 'CA';
$area_codes['214'] = 'TX';
$area_codes['215'] = 'PA';
$area_codes['216'] = 'OH';
$area_codes['217'] = 'IL';
$area_codes['218'] = 'MN';
$area_codes['219'] = 'IN';
$area_codes['224'] = 'IL';
$area_codes['225'] = 'LA';
$area_codes['226'] = 'ON';
$area_codes['228'] = 'MS';
$area_codes['229'] = 'GA';
$area_codes['231'] = 'MI';
$area_codes['234'] = 'OH';
$area_codes['236'] = 'BC';
$area_codes['239'] = 'FL';
$area_codes['240'] = 'MD';
$area_codes['248'] = 'MI';
$area_codes['250'] = 'BC';
$area_codes['251'] = 'AL';
$area_codes['252'] = 'NC';
$area_codes['253'] = 'WA';
$area_codes['254'] = 'TX';
$area_codes['256'] = 'AL';
$area_codes['260'] = 'IN';
$area_codes['262'] = 'WI';
$area_codes['267'] = 'PA';
$area_codes['269'] = 'MI';
$area_codes['270'] = 'KY';
$area_codes['276'] = 'VA';
$area_codes['278'] = 'MI';
$area_codes['281'] = 'TX';
$area_codes['283'] = 'OH';
$area_codes['289'] = 'ON';
$area_codes['301'] = 'MD';
$area_codes['302'] = 'DE';
$area_codes['303'] = 'CO';
$area_codes['304'] = 'WV';
$area_codes['305'] = 'FL';
$area_codes['306'] = 'SK';
$area_codes['307'] = 'WY';
$area_codes['308'] = 'NE';
$area_codes['309'] = 'IL';
$area_codes['310'] = 'CA';
$area_codes['312'] = 'IL';
$area_codes['313'] = 'MI';
$area_codes['314'] = 'MO';
$area_codes['315'] = 'NY';
$area_codes['316'] = 'KS';
$area_codes['317'] = 'IN';
$area_codes['318'] = 'LA';
$area_codes['319'] = 'IA';
$area_codes['320'] = 'MN';
$area_codes['321'] = 'FL';
$area_codes['323'] = 'CA';
$area_codes['325'] = 'TX';
$area_codes['330'] = 'OH';
$area_codes['331'] = 'IL';
$area_codes['334'] = 'AL';
$area_codes['336'] = 'NC';
$area_codes['337'] = 'LA';
$area_codes['339'] = 'MA';
$area_codes['340'] = 'VI';
$area_codes['341'] = 'CA';
$area_codes['343'] = 'ON';
$area_codes['347'] = 'NY';
$area_codes['351'] = 'MA';
$area_codes['352'] = 'FL';
$area_codes['360'] = 'WA';
$area_codes['361'] = 'TX';
$area_codes['365'] = 'ON';
$area_codes['369'] = 'CA';
$area_codes['380'] = 'OH';
$area_codes['385'] = 'UT';
$area_codes['386'] = 'FL';
$area_codes['401'] = 'RI';
$area_codes['402'] = 'NE';
$area_codes['403'] = 'AB';
$area_codes['404'] = 'GA';
$area_codes['405'] = 'OK';
$area_codes['406'] = 'MT';
$area_codes['407'] = 'FL';
$area_codes['408'] = 'CA';
$area_codes['409'] = 'TX';
$area_codes['410'] = 'MD';
$area_codes['412'] = 'PA';
$area_codes['413'] = 'MA';
$area_codes['414'] = 'WI';
$area_codes['415'] = 'CA';
$area_codes['416'] = 'ON';
$area_codes['417'] = 'MO';
$area_codes['418'] = 'QC';
$area_codes['419'] = 'OH';
$area_codes['423'] = 'TN';
$area_codes['424'] = 'CA';
$area_codes['425'] = 'WA';
$area_codes['430'] = 'TX';
$area_codes['431'] = 'MB';
$area_codes['432'] = 'TX';
$area_codes['434'] = 'VA';
$area_codes['435'] = 'UT';
$area_codes['437'] = 'ON';
$area_codes['438'] = 'QC';
$area_codes['440'] = 'OH';
$area_codes['442'] = 'CA';
$area_codes['443'] = 'MD';
$area_codes['450'] = 'QC';
$area_codes['464'] = 'IL';
$area_codes['469'] = 'TX';
$area_codes['470'] = 'GA';
$area_codes['475'] = 'CT';
$area_codes['478'] = 'GA';
$area_codes['479'] = 'AR';
$area_codes['480'] = 'AZ';
$area_codes['481'] = 'QC';
$area_codes['484'] = 'PA';
$area_codes['501'] = 'AR';
$area_codes['502'] = 'KY';
$area_codes['503'] = 'OR';
$area_codes['504'] = 'LA';
$area_codes['505'] = 'NM';
$area_codes['506'] = 'NB';
$area_codes['507'] = 'MN';
$area_codes['508'] = 'MA';
$area_codes['509'] = 'WA';
$area_codes['510'] = 'CA';
$area_codes['512'] = 'TX';
$area_codes['513'] = 'OH';
$area_codes['514'] = 'QC';
$area_codes['515'] = 'IA';
$area_codes['516'] = 'NY';
$area_codes['517'] = 'MI';
$area_codes['518'] = 'NY';
$area_codes['519'] = 'ON';
$area_codes['520'] = 'AZ';
$area_codes['530'] = 'CA';
$area_codes['539'] = 'OK';
$area_codes['540'] = 'VA';
$area_codes['541'] = 'OR';
$area_codes['548'] = 'ON';
$area_codes['551'] = 'NJ';
$area_codes['557'] = 'MO';
$area_codes['559'] = 'CA';
$area_codes['561'] = 'FL';
$area_codes['562'] = 'CA';
$area_codes['563'] = 'IA';
$area_codes['564'] = 'WA';
$area_codes['567'] = 'OH';
$area_codes['570'] = 'PA';
$area_codes['571'] = 'VA';
$area_codes['573'] = 'MO';
$area_codes['574'] = 'IN';
$area_codes['575'] = 'NM';
$area_codes['579'] = 'QC';
$area_codes['580'] = 'OK';
$area_codes['585'] = 'NY';
$area_codes['586'] = 'MI';
$area_codes['587'] = 'AB';
$area_codes['601'] = 'MS';
$area_codes['602'] = 'AZ';
$area_codes['603'] = 'NH';
$area_codes['604'] = 'BC';
$area_codes['605'] = 'SD';
$area_codes['606'] = 'KY';
$area_codes['607'] = 'NY';
$area_codes['608'] = 'WI';
$area_codes['609'] = 'NJ';
$area_codes['610'] = 'PA';
$area_codes['612'] = 'MN';
$area_codes['613'] = 'ON';
$area_codes['614'] = 'OH';
$area_codes['615'] = 'TN';
$area_codes['616'] = 'MI';
$area_codes['617'] = 'MA';
$area_codes['618'] = 'IL';
$area_codes['619'] = 'CA';
$area_codes['620'] = 'KS';
$area_codes['623'] = 'AZ';
$area_codes['626'] = 'CA';
$area_codes['627'] = 'CA';
$area_codes['628'] = 'CA';
$area_codes['630'] = 'IL';
$area_codes['631'] = 'NY';
$area_codes['636'] = 'MO';
$area_codes['639'] = 'SK';
$area_codes['641'] = 'IA';
$area_codes['646'] = 'NY';
$area_codes['647'] = 'ON';
$area_codes['650'] = 'CA';
$area_codes['651'] = 'MN';
$area_codes['657'] = 'CA';
$area_codes['660'] = 'MO';
$area_codes['661'] = 'CA';
$area_codes['662'] = 'MS';
$area_codes['669'] = 'CA';
$area_codes['670'] = 'MP';
$area_codes['671'] = 'GU';
$area_codes['678'] = 'GA';
$area_codes['679'] = 'MI';
$area_codes['681'] = 'WV';
$area_codes['682'] = 'TX';
$area_codes['689'] = 'FL';
$area_codes['701'] = 'ND';
$area_codes['702'] = 'NV';
$area_codes['703'] = 'VA';
$area_codes['704'] = 'NC';
$area_codes['705'] = 'ON';
$area_codes['706'] = 'GA';
$area_codes['707'] = 'CA';
$area_codes['708'] = 'IL';
$area_codes['709'] = 'NL';
$area_codes['712'] = 'IA';
$area_codes['713'] = 'TX';
$area_codes['714'] = 'CA';
$area_codes['715'] = 'WI';
$area_codes['716'] = 'NY';
$area_codes['717'] = 'PA';
$area_codes['718'] = 'NY';
$area_codes['719'] = 'CO';
$area_codes['720'] = 'CO';
$area_codes['724'] = 'PA';
$area_codes['727'] = 'FL';
$area_codes['731'] = 'TN';
$area_codes['732'] = 'NJ';
$area_codes['734'] = 'MI';
$area_codes['737'] = 'TX';
$area_codes['740'] = 'OH';
$area_codes['747'] = 'CA';
$area_codes['754'] = 'FL';
$area_codes['757'] = 'VA';
$area_codes['760'] = 'CA';
$area_codes['762'] = 'GA';
$area_codes['763'] = 'MN';
$area_codes['764'] = 'CA';
$area_codes['765'] = 'IN';
$area_codes['769'] = 'MS';
$area_codes['770'] = 'GA';
$area_codes['772'] = 'FL';
$area_codes['773'] = 'IL';
$area_codes['774'] = 'MA';
$area_codes['775'] = 'NV';
$area_codes['778'] = 'BC';
$area_codes['779'] = 'IL';
$area_codes['780'] = 'AB';
$area_codes['781'] = 'MA';
$area_codes['782'] = 'NS';
$area_codes['785'] = 'KS';
$area_codes['786'] = 'FL';
$area_codes['787'] = 'PR';
$area_codes['801'] = 'UT';
$area_codes['802'] = 'VT';
$area_codes['803'] = 'SC';
$area_codes['804'] = 'VA';
$area_codes['805'] = 'CA';
$area_codes['806'] = 'TX';
$area_codes['807'] = 'ON';
$area_codes['808'] = 'HI';
$area_codes['810'] = 'MI';
$area_codes['812'] = 'IN';
$area_codes['813'] = 'FL';
$area_codes['814'] = 'PA';
$area_codes['815'] = 'IL';
$area_codes['816'] = 'MO';
$area_codes['817'] = 'TX';
$area_codes['818'] = 'CA';
$area_codes['819'] = 'QC';
$area_codes['825'] = 'AB';
$area_codes['828'] = 'NC';
$area_codes['830'] = 'TX';
$area_codes['831'] = 'CA';
$area_codes['832'] = 'TX';
$area_codes['835'] = 'PA';
$area_codes['843'] = 'SC';
$area_codes['845'] = 'NY';
$area_codes['847'] = 'IL';
$area_codes['848'] = 'NJ';
$area_codes['850'] = 'FL';
$area_codes['856'] = 'NJ';
$area_codes['857'] = 'MA';
$area_codes['858'] = 'CA';
$area_codes['859'] = 'KY';
$area_codes['860'] = 'CT';
$area_codes['862'] = 'NJ';
$area_codes['863'] = 'FL';
$area_codes['864'] = 'SC';
$area_codes['865'] = 'TN';
$area_codes['867'] = 'YT';
$area_codes['870'] = 'AR';
$area_codes['872'] = 'IL';
$area_codes['873'] = 'QC';
$area_codes['878'] = 'PA';
$area_codes['901'] = 'TN';
$area_codes['902'] = 'NS';
$area_codes['903'] = 'TX';
$area_codes['904'] = 'FL';
$area_codes['905'] = 'ON';
$area_codes['906'] = 'MI';
$area_codes['907'] = 'AK';
$area_codes['908'] = 'NJ';
$area_codes['909'] = 'CA';
$area_codes['910'] = 'NC';
$area_codes['912'] = 'GA';
$area_codes['913'] = 'KS';
$area_codes['914'] = 'NY';
$area_codes['915'] = 'TX';
$area_codes['916'] = 'CA';
$area_codes['917'] = 'NY';
$area_codes['918'] = 'OK';
$area_codes['919'] = 'NC';
$area_codes['920'] = 'WI';
$area_codes['925'] = 'CA';
$area_codes['927'] = 'FL';
$area_codes['928'] = 'AZ';
$area_codes['931'] = 'TN';
$area_codes['935'] = 'CA';
$area_codes['936'] = 'TX';
$area_codes['937'] = 'OH';
$area_codes['939'] = 'PR';
$area_codes['940'] = 'TX';
$area_codes['941'] = 'FL';
$area_codes['947'] = 'MI';
$area_codes['949'] = 'CA';
$area_codes['951'] = 'CA';
$area_codes['952'] = 'MN';
$area_codes['954'] = 'FL';
$area_codes['956'] = 'TX';
$area_codes['957'] = 'NM';
$area_codes['959'] = 'CT';
$area_codes['970'] = 'CO';
$area_codes['971'] = 'OR';
$area_codes['972'] = 'TX';
$area_codes['973'] = 'NJ';
$area_codes['975'] = 'MO';
$area_codes['978'] = 'MA';
$area_codes['979'] = 'TX';
$area_codes['980'] = 'NC';
$area_codes['984'] = 'NC';
$area_codes['985'] = 'LA';
$area_codes['989'] = 'MI';


 
  
if(isset($area_codes[$areacode]) && !empty($area_codes[$areacode])) {
    $result = $area_codes[$areacode];
}


    if(isset($result) && !empty($result)) {
        return $result;
    } else {
        return null;
    }



}