<?php 

    /* Config
    **************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/_config/_config.php";

    /* Functions
    **************************************************** */
    include_once ($_SERVER["DOCUMENT_ROOT"]."/_libraries/functions.php");

    // First we execute our common code to connection to the database and start the session 
    require($_SERVER["DOCUMENT_ROOT"]."/_libraries/login/common.php"); 
     

    // At the top of the page we check to see whether the user is logged in or not
    if(empty($_SESSION['user']))
    {
        // If they are not, we redirect them to the login page.
        header("Location: /login/");

        // Remember that this die statement is absolutely critical.  Without it,
        // people can view your members-only content without logging in.
        die("Redirecting to login page...");

    } else {
        
        //Token
        removeToken($_SESSION['user']['id'],$_SESSION['user']['token']);
        
    }

    // We remove the user's data from the session 
    unset($_SESSION['user']); 
    session_unset();
    session_destroy();


    // We redirect them to the login page 
    header("Location: /"); 
    die("Redirecting to Login page...");