<?php

namespace mageekguy\atoum\tests\units\report\fields\test\duration;

use mageekguy\atoum;
use mageekguy\atoum\cli\colorizer;
use mageekguy\atoum\cli\prompt;
use mageekguy\atoum\locale;
use mageekguy\atoum\mock;
use mageekguy\atoum\report\fields\test;
use mageekguy\atoum\test\adapter;

require_once __DIR__ . '/../../../../../runner.php';

class phing extends atoum\test
{
    public function testClass()
    {
        $this->testedClass->extends(atoum\report\fields\test\duration\cli::class);
    }

    public function test__construct()
    {
        $this
            ->if($field = new test\duration\phing())
            ->then
                ->object($field->getPrompt())->isEqualTo(new prompt())
                ->object($field->getTitleColorizer())->isEqualTo(new colorizer())
                ->object($field->getDurationColorizer())->isEqualTo(new colorizer())
                ->object($field->getLocale())->isEqualTo(new locale())
                ->variable($field->getValue())->isNull()
                ->array($field->getEvents())->isEqualTo([atoum\test::runStop])
        ;
    }

    public function testSetPrompt()
    {
        $this
            ->if($field = new test\duration\phing())
            ->then
                ->object($field->setPrompt($prompt = new prompt()))->isIdenticalTo($field)
                ->object($field->getPrompt())->isIdenticalTo($prompt)
                ->object($field->setPrompt())->isIdenticalTo($field)
                ->object($field->getPrompt())
                    ->isNotIdenticalTo($prompt)
                    ->isEqualTo(new prompt())
        ;
    }

    public function testSetTitleColorizer()
    {
        $this
            ->if($field = new test\duration\phing())
            ->then
                ->object($field->setTitleColorizer($colorizer = new colorizer()))->isIdenticalTo($field)
                ->object($field->getTitleColorizer())->isIdenticalTo($colorizer)
                ->object($field->setTitleColorizer())->isIdenticalTo($field)
                ->object($field->getTitleColorizer())
                    ->isNotIdenticalTo($colorizer)
                    ->isEqualTo(new colorizer())
        ;
    }

    public function testSetDurationColorizer()
    {
        $this
            ->if($field = new test\duration\phing())
            ->then
                ->object($field->setDurationColorizer($colorizer = new colorizer()))->isIdenticalTo($field)
                ->object($field->getDurationColorizer())->isIdenticalTo($colorizer)
                ->object($field->setDurationColorizer())->isIdenticalTo($field)
                ->object($field->getDurationColorizer())
                    ->isNotIdenticalTo($colorizer)
                    ->isEqualTo(new colorizer())
        ;
    }

    public function testSetLocale()
    {
        $this
            ->if($field = new test\duration\phing())
            ->then
                ->object($field->setLocale($locale = new atoum\locale()))->isIdenticalTo($field)
                ->object($field->getLocale())->isIdenticalTo($locale)
                ->object($field->setLocale())->isIdenticalTo($field)
                ->object($field->getLocale())
                    ->isNotIdenticalTo($locale)
                    ->isEqualTo(new atoum\locale())
        ;
    }

    public function testHandleEvent()
    {
        $this
            ->if($field = new test\duration\phing())
            ->and($score = new \mock\mageekguy\atoum\score())
            ->and($score->getMockController()->getTotalDuration = function () use (& $runningDuration) {
                return $runningDuration = rand(0, PHP_INT_MAX);
            })
            ->and($adapter = new adapter())
            ->and($adapter->class_exists = true)
            ->and($testController = new mock\controller())
            ->and($testController->getTestedClassName = uniqid())
            ->and($testController->getScore = $score)
            ->and($test = new \mock\mageekguy\atoum\test($adapter))
            ->then
                ->boolean($field->handleEvent(atoum\runner::runStop, $test))->isFalse()
                ->variable($field->getValue())->isNull()
                ->boolean($field->handleEvent(atoum\test::runStop, $test))->isTrue()
                ->integer($field->getValue())->isEqualTo($runningDuration)
        ;
    }

    public function test__toString()
    {
        $this
            ->if($adapter = new adapter())
            ->and($adapter->class_exists = true)
            ->and($score = new \mock\mageekguy\atoum\score())
            ->and($score->getMockController()->getTotalDuration = $runningDuration = rand(1, 1000) / 1000)
            ->and($testController = new mock\controller())
            ->and($testController->getTestedClassName = uniqid())
            ->and($testController->getScore = $score)
            ->and($test = new \mock\mageekguy\atoum\test($adapter))
            ->and($defaultField = new test\duration\phing())
            ->and($customField = new test\duration\phing())
            ->and($customField->setPrompt($prompt = new prompt()))
            ->and($customField->setTitleColorizer($titleColorizer = new colorizer()))
            ->and($customField->setDurationColorizer($durationColorizer = new colorizer()))
            ->and($customField->setLocale($locale = new locale()))
            ->then
                ->castToString($defaultField)->isEqualTo('unknown')
                ->castToString($customField)->isEqualTo(
                        $prompt .
                        sprintf(
                            '%s',
                            $locale->_('unknown')
                        )
                    )
            ->if($defaultField->handleEvent(atoum\runner::runStop, $test))
            ->then
                ->castToString($defaultField)->isEqualTo('unknown')
            ->if($customField->handleEvent(atoum\runner::runStop, $test))
            ->then
                ->castToString($customField)->isEqualTo(
                        $prompt .
                        sprintf(
                            '%s',
                            $locale->_('unknown')
                        )
                    )
            ->if($defaultField->handleEvent(atoum\test::runStop, $test))
            ->then
                ->castToString($defaultField)->isEqualTo(sprintf('%4.2f s', $runningDuration))
            ->if($customField->handleEvent(atoum\test::runStop, $test))
            ->then
                ->castToString($customField)->isEqualTo(
                        $prompt .
                        sprintf(
                            '%s',
                            $durationColorizer->colorize(sprintf($locale->__('%4.2f s', '%4.2f s', $runningDuration), $runningDuration))
                        )
                    )
            ->if($score->getMockController()->getTotalDuration = $runningDuration = rand(2, PHP_INT_MAX))
            ->and($defaultField = new test\duration\phing())
            ->and($customField = new test\duration\phing())
            ->and($customField->setPrompt($prompt = new prompt()))
            ->and($customField->setTitleColorizer($titleColorizer = new colorizer()))
            ->and($customField->setDurationColorizer($durationColorizer = new colorizer()))
            ->and($customField->setLocale($locale = new locale()))
            ->then
                ->castToString($defaultField)->isEqualTo('unknown')
                ->castToString($customField)->isEqualTo(
                        $prompt .
                        sprintf(
                            '%s',
                            $locale->_('unknown')
                        )
                    )
            ->if($defaultField->handleEvent(atoum\runner::runStop, $test))
            ->then
                ->castToString($defaultField)->isEqualTo('unknown')
            ->if($customField->handleEvent(atoum\runner::runStop, $test))
            ->then
                ->castToString($customField)->isEqualTo(
                        $prompt .
                        sprintf(
                            '%s',
                            $locale->_('unknown')
                        )
                    )
            ->if($defaultField->handleEvent(atoum\test::runStop, $test))
            ->then
                ->castToString($defaultField)->isEqualTo(sprintf('%4.2f s', $runningDuration))
            ->if($customField->handleEvent(atoum\test::runStop, $test))
            ->then
                ->castToString($customField)->isEqualTo(
                        $prompt .
                        sprintf(
                            '%s',
                            $durationColorizer->colorize(sprintf($locale->__('%4.2f s', '%4.2f s', $runningDuration), $runningDuration))
                        )
                    )
        ;
    }
}
