<?php

/* ####################################  
   CORS                             
   #################################### */

    // * wont work in FF w/ Allow-Credentials
    //if you dont need Allow-Credentials, * seems to work
    header('Access-Control-Allow-Origin: *');
    //if you need cookies or login etc
    //header('Access-Control-Allow-Credentials: true');
    if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS')
    {
      header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
      header('Access-Control-Max-Age: 604800');
      //if you need special headers
      header('Access-Control-Allow-Headers: x-requested-with');
      exit(0);
    }

/* ####################################  
   Includes                            
   #################################### */

    include ($_SERVER['DOCUMENT_ROOT'].'/_config/_config.php');


    include ($_SERVER['DOCUMENT_ROOT'].'/_libraries/functions.php');


/* ####################################  
   Content type                              
   #################################### */

    header('Content-Type: application/json');


    /**********************************  
        AUTH                            
    **********************************/

        // Check if user/password auth
        if ( $_REQUEST['res'] == 'likes' || $_REQUEST['res'] == 'views' || (isset($_REQUEST['subAction']) && $_REQUEST['subAction'] == 'reset-password') ) {
            
        } else if ( isset($_REQUEST[$GLOBALS['aPiUsrNm']])   && $_REQUEST[$GLOBALS['aPiUsrNm']] != '' &&  isset($_REQUEST[$GLOBALS['aPiPswRd']]) && $_REQUEST[$GLOBALS['aPiPswRd']] !='' ) {
        
            
            if ( ($_REQUEST[$GLOBALS['aPiUsrNm']]!=$GLOBALS['aPiUsrNmVaLue']) and ($_REQUEST[$GLOBALS['aPiPswRd']]!=$GLOBALS['aPiPswRdVaLue'] ) ) {
            
                $errors[] = 'Authorization failed. Error code: 5203.';
                
            }
            
        } else if (isset($_REQUEST['api_key']) && $_REQUEST['api_key'] != '') {

            try {
                        /* Connection
                        **************************************************** */
                        $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);
                        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                        $conn->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

                        /* Query
                        **************************************************** */
                        $query = 'SELECT api_key FROM '.$GLOBALS['db_prefix'].'system WHERE api_key = :api_key';
                        $data = $conn->prepare($query);
                        $data->execute(array('api_key' => $_REQUEST['api_key']));
                        $result = $data->fetch();

                        if ( count($result) > 0 ) {
                            
                            $api_key = $result['api_key'];

                                if ( $api_key != $_REQUEST['api_key']){

                                    $errors[] = 'Authorization failed. Error code: 5204.';

                                }
                            

                        } else {

                            $errors[] = 'Authorization failed. Error code: 5205.';

                        }

                    } catch(PDOException $e) { $errors[] = $e->getMessage();}


        } else {
            
                // Check if token auth

                if ( !isset($_REQUEST['token']) || $_REQUEST['token'] == '') {

                    $errors[] = 'Authorization failed. Error code: 5200.';

                } else {

                    try {
                        /* Connection
                        **************************************************** */
                        $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_database'], $GLOBALS['db_user'], $GLOBALS['db_pass']);
                        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                        $conn->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);

                        /* Query
                        **************************************************** */
                        $query = 'SELECT token,token_expire,id FROM '.$GLOBALS['db_prefix'].'users WHERE token = :token';
                        $data = $conn->prepare($query);
                        $data->execute(array('token' => $_REQUEST['token']));
                        $result = $data->fetchAll();

                        if ( count($result) > 0 ) {
                            foreach($result as $row) {

                                $tokenGeneric = $GLOBALS['SECRET_KEY'].$row['id']; // It can be 'stronger' of course
                                $token = hash('sha256', $tokenGeneric);

                                if ( $token != $_REQUEST['token']){

                                    $errors[] = 'Authorization failed. Error code: 5201.';

                                }
                            }

                        } else {

                            $errors[] = 'Authorization failed. Error code: 5203.';

                        }

                    } catch(PDOException $e) { $errors[] = $e->getMessage();}
                }
        
        }


/* ####################################  
    Cache                              
   #################################### */


    /* Cache Start */
    if ($GLOBALS['mode_cache_api']==true) {
        require ('_includes/CachingStart.php');
    } 

    


/* ####################################  
   Errors                             
   #################################### */

    if ( isset($errors) ) {

        include_once ($_SERVER['DOCUMENT_ROOT'].'/_libraries/error_handler.php');

    } else {
        /* Get api Action */
        if ( isset($_REQUEST['action']) && $_REQUEST['action'] !='' ) {
                if ( isset($_REQUEST['res']) && $_REQUEST['res'] !='' ) {

                    require ('_modules/var.php');
                    //require ('_modules/'.$_REQUEST['res'].'-var.php');
                    require ($_REQUEST['action'].'/'.$_REQUEST['res'].'Controller.php');
                 
                }

        } else { }
    }


/* ####################################  
   Cache End                            
   #################################### */

    if ($_REQUEST['action'] == 'GET' && $GLOBALS['mode_cache_api']==true) {
        require ('_includes/CachingEnd.php');
    }


?>
