<?php

/* Config
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/_config/_config.php";


/* Templateing & Caching System - Start
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/TemplatingSystemStart.php";


/* Private
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/_libraries/login/private.php";


/* Systems Handle & Control
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/SystemsHandle.php";

/* Required Calls
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/RequiredCalls.php";




    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


    $date = date('d-m-y-'.substr((string)microtime(), 1, 8));
    $date = str_replace(".", "", $date);
    $filename = "export_".$date.".xlsx";



$position='';
 if(isset($_REQUEST['position']) && $_REQUEST['position']!='') {

    if($_REQUEST['position']!='all') {

        $position = "&position=".$_REQUEST['position']."";
 
    } else {

        $position = "";
    }
 
    $smarty->assign('position_form', $_REQUEST['position']);
 }


 $status='';
  if(isset($_REQUEST['status']) && $_REQUEST['status']!='') {

    if($_REQUEST['status']!='all') {

        $status = "&status=".$_REQUEST['status']."";
    
    } else {

        $status= "";        
    }
    
    $smarty->assign('status_form', $_REQUEST['status']);
 }


 $source='';
  if(isset($_REQUEST['source']) && $_REQUEST['source']!='') {

    if($_REQUEST['source']!='all') {

    $source = "&source=".$_REQUEST['source']."";
    
    } else {

    $source= "";      
    }
  
  $smarty->assign('source_form', $_REQUEST['source']);
 }


 $ref='';
  if(isset($_REQUEST['ref']) && $_REQUEST['ref']!='') {

    if($_REQUEST['ref']!='all') {

    $ref = "&ref=".$_REQUEST['ref']."";
    
    } else {

    $ref= "";      
    }
  
  $smarty->assign('ref_form', $_REQUEST['ref']);
 }


 $l_search='';
  if(isset($_REQUEST['l_search']) && $_REQUEST['l_search']!='') {

    if($_REQUEST['l_search']!='') {

    $l_search = "&l_search=".$_REQUEST['l_search']."";
    $l_search = str_replace(' ', '%20', $l_search);
    
    } else {

    $l_search= "";      
    }
  
  $smarty->assign('l_search_form', $_REQUEST['l_search']);
 }



// MANAGER
if(in_array("recruiting-manager", $current_logged_user['data']['users'][0]['obligations'])) {
    
  $list_leads = api_call('/GET/recruiting/leads/?limit=false&active=1'.$position.$status.$source.$ref.$l_search.'',true,$_SESSION['user']['token']);

 
// RECRUITER
} elseif (in_array("recruiter", $current_logged_user['data']['users'][0]['obligations'])) {

  $list_leads = api_call('/GET/recruiting/leads/?limit=false&active=1&recruiter='.$_SESSION['user']['uid'].$position.$status.$source.$ref.$l_search.'',true,$_SESSION['user']['token']);

}



    $rowCount=1;

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setCellValue('A'.$rowCount, 'Name');
    $sheet->setCellValue('B'.$rowCount, 'Phone');
    $sheet->setCellValue('C'.$rowCount, 'License Number');
    $sheet->setCellValue('D'.$rowCount, 'State');
    $sheet->setCellValue('E'.$rowCount, 'Zip');
    $sheet->setCellValue('F'.$rowCount, 'Email');

    $rowCount++;


    foreach ($list_leads['data']['leads'] as $lead) {
        
        $sheet->setCellValue('A'.$rowCount, "".$lead['first_name']." ".$lead['last_name']."");
        $sheet->setCellValue('B'.$rowCount, "".$lead['phone_e164']."");
        $sheet->setCellValue('C'.$rowCount, "".$lead['ln']."");
        $sheet->setCellValue('D'.$rowCount, "".$lead['state_province']."");
        $sheet->setCellValue('E'.$rowCount, "".$lead['zip']."");
        $sheet->setCellValue('F'.$rowCount, "".$lead['email']."");
        // code...

        $rowCount++;
    }


    $writer = new Xlsx($spreadsheet);
    $writer->save($GLOBALS['app_folder_path'].$filename);


    // Redirect output to a client’s web browser (Xlsx)
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment;filename="'.$filename.'"');
    header('Cache-Control: max-age=0');
    // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');

    // If you're serving to IE over SSL, then the following may be needed
    header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
    header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
    header('Pragma: public'); // HTTP/1.0

    $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
    
    if (ob_get_contents()) {
        ob_end_clean();
    }
    
    
    
    $writer->save('php://output');

    exit;