<?php
session_start();
// SET Headers
// header('Content-Type: application/json; charset=UTF-8'); 

/* Config
**************************************************** */
require $_SERVER['DOCUMENT_ROOT'].'/_libraries/vendor/autoload.php';
// use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

require $_SERVER["DOCUMENT_ROOT"]."/_config/_config.php";
include_once ($_SERVER["DOCUMENT_ROOT"]."/_libraries/functions.php");
include ($_SERVER['DOCUMENT_ROOT'].'/api/_includes/file-uploader/class.uploader.php');

if (isset($_FILES['file']) && $_FILES['file']!=='') {
	
	// var_dump($_FILES['file']); 

	$time = time();

	$uploader = new Uploader();
	$data = $uploader->upload($_FILES['file'], array(
	    'limit' => 1, //Maximum Limit of files. {null, Number}
	    'maxSize' => 5, //Maximum Size of files {null, Number(in MB's)}
	    'extensions' => array('csv'), //Whitelist for file extension. {null, Array(ex: array('jpg', 'png'))}
	    'required' => true, //Minimum one file is required for upload {Boolean}
	    'uploadDir' => $GLOBALS['app_folder_path'].'leads/', //Upload directory {String}
	    'title' => $_FILES['file']['name']."-".$time, //New file name {null, String, Array} *please read documentation in README.md
	    'removeFiles' => true, //Enable file exclusion {Boolean(extra for jQuery.filer), String($_POST field name containing json data with file names)}
	    'perms' => null, //Uploaded file permisions {null, Number}
	    'onCheck' => null, //A callback function name to be called by checking a file for errors (must return an array) | ($file) | Callback
	    'onError' => null, //A callback function name to be called if an error occured (must return an array) | ($errors, $file) | Callback
	    'onSuccess' => null, //A callback function name to be called if all files were successfully uploaded | ($files, $metas) | Callback
	    'onUpload' => null, //A callback function name to be called if all files were successfully uploaded (must return an array) | ($file) | Callback
	    'onComplete' => null, //A callback function name to be called when upload is complete | ($file) | Callback
	    'onRemove' => 'null' //A callback function name to be called by removing files (must return an array) | ($removed_files) | Callback
	));

	// var_dump($data); exit;

	if($data['isSuccess']) {


		$spreadsheet = new Spreadsheet();

		$inputFileType = 'Csv';
		$inputFileName = $data['data']['files'][0];

		/**  Create a new Reader of the type defined in $inputFileType  **/
		$reader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
		/**  Advise the Reader that we only want to load cell data  **/
		$reader->setReadDataOnly(true);

		$worksheetData = $reader->listWorksheetInfo($inputFileName);

		foreach ($worksheetData as $worksheet) {

		$sheetName = $worksheet['worksheetName'];

		// echo "<h4>$sheetName</h4>";
		/**  Load $inputFileName to a Spreadsheet Object  **/
		$reader->setLoadSheetsOnly($sheetName);
		$spreadsheet = $reader->load($inputFileName);

		$worksheet = $spreadsheet->getActiveSheet();
		$worksheet = $worksheet->toArray();
		// array_shift($worksheet);

		$json = json_encode($worksheet, true);

		// echo $json; exit;
		// print_r($worksheet->toArray());

		}

		// echo $json; exit;

		if($worksheet[0][0]=='first_name' 
			&& $worksheet[0][1]=='last_name' 
			&& $worksheet[0][2]=='middle_initial' 
			&& $worksheet[0][3]=='email' 
			&& $worksheet[0][4]=='phone'
			&& $worksheet[0][5]=='position'
			&& $worksheet[0][6]=='birth'
			&& $worksheet[0][7]=='home_address'
			&& $worksheet[0][8]=='country'
			&& $worksheet[0][9]=='state_province'
			&& $worksheet[0][10]=='city'
			&& $worksheet[0][11]=='zip'
			&& $worksheet[0][12]=='ssn'
			&& $worksheet[0][13]=='emergency_first_name'
			&& $worksheet[0][14]=='emergency_last_name'
			&& $worksheet[0][15]=='emergency_email'
			&& $worksheet[0][16]=='emergency_phone'
			&& $worksheet[0][17]=='dui'
			&& $worksheet[0][18]=='convicted'
			&& $worksheet[0][19]=='ln'
			&& $worksheet[0][20]=='ls'
			&& $worksheet[0][21]=='licenceIssuing'
			&& $worksheet[0][22]=='licence_expiration'
			&& $worksheet[0][23]=='years_of_driving_experience'
			&& $worksheet[0][24]=='manual_transmision'
			&& $worksheet[0][25]=='accident'
			&& $worksheet[0][26]=='denied_license'
			&& $worksheet[0][27]=='denied_license_explaination'
			&& $worksheet[0][28]=='suspended_license'
			&& $worksheet[0][29]=='suspended_license_explaination'
			&& $worksheet[0][30]=='team_solo_both'
			&& $worksheet[0][31]=='previous_employer_contact'
			&& $worksheet[0][32]=='otr_or_regional'
			&& $worksheet[0][33]=='english_fluently'
			&& $worksheet[0][34]=='other_language'
			&& $worksheet[0][35]=='recruiter') {

			array_shift($worksheet);

		foreach ($worksheet as $a) {
			
			// var_dump($a);
			try {
		        /* Connection
		        **************************************************** */
		        $conn = new PDO("mysql:host=".$GLOBALS['db_host'].";dbname=".$GLOBALS['db_recruiting_database'], $GLOBALS['db_recruiting_user'], $GLOBALS['db_recruiting_pass']);
		        $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
		        $conn->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
		        $conn->exec("set names utf8");
		        
		               $first_name = $a[0];
		               $last_name = $a[1];
		               $middle_initial = $a[2];
		               $email = $a[3];
		               $phone = $a[4];
		               $position = $a[5];
		               $birth = $a[6];
		               $home_address = $a[7];
		               $country = $a[8];
		               $state_province = $a[9];
		               $city = $a[10];
		               $zip = $a[11];
		               $ssn = $a[12];
		               $emergency_first_name = $a[13];
		               $emergency_last_name = $a[14];
		               $emergency_email = $a[15];
		               $emergency_phone = $a[16];
		               $dui = $a[17];
		               $convicted = $a[18];
		               $ln = $a[19];
		               $ls = $a[20];
		               $licenceIssuing = $a[21];
		               $licence_expiration = $a[22];
		               $years_of_driving_experience = $a[23];
		               $manual_transmision = $a[24];
		               $accident = $a[25];
		               $denied_license = $a[26];
		               $denied_license_explaination = $a[27];
		               $suspended_license = $a[28];
		               $suspended_license_explaination = $a[29];
		               $team_solo_both = $a[30];
		               $previous_employer_contact = $a[31];
		               $otr_or_regional = $a[32];
		               $english_fluently = $a[33];
		               $other_language = $a[34];
		               $recruiter = $a[35];
		              
		               $uid = get_random_string();

		               if(isset($phone) && $phone!=''){
		               		$phone_e164 = formatPhone($phone);
		               } else {
		               		$phone_e164 = NULL;
		               }

		 
		                
		                try {
		                    $data2 = $conn->prepare('INSERT INTO '.$GLOBALS['db_prefix'].'leads (
		                        first_name,
								last_name,
								middle_initial,
								email,
								phone,
								phone_e164,
								position,
								birth,
								home_address,
								country,
								state_province,
								city,
								zip,
								ssn,
								emergency_first_name,
								emergency_last_name,
								emergency_email,
								emergency_phone,
								dui,
								convicted,
								ln,
								ls,
								licenceIssuing,
								licence_expiration,
								years_of_driving_experience,
								manual_transmision,
								accident,
								denied_license,
								denied_license_explaination,
								suspended_license,
								suspended_license_explaination,
								team_solo_both,
								previous_employer_contact,
								otr_or_regional,
								english_fluently,
								other_language,
								recruiter,
								status,
								uid
		                        
		                        
		                    ) VALUES ( 
		                        :first_name,
								:last_name,
								:middle_initial,
								:email,
								:phone,
								:phone_e164,
								:position,
								:birth,
								:home_address,
								:country,
								:state_province,
								:city,
								:zip,
								:ssn,
								:emergency_first_name,
								:emergency_last_name,
								:emergency_email,
								:emergency_phone,
								:dui,
								:convicted,
								:ln,
								:ls,
								:licenceIssuing,
								:licence_expiration,
								:years_of_driving_experience,
								:manual_transmision,
								:accident,
								:denied_license,
								:denied_license_explaination,
								:suspended_license,
								:suspended_license_explaination,
								:team_solo_both,
								:previous_employer_contact,
								:otr_or_regional,
								:english_fluently,
								:other_language,
								:recruiter,
								:status,
		                        :uid
		                         
		                    )');
		                    $data2->execute(
		                        array(
		                            'first_name' => $first_name,
									'last_name' => $last_name,
									'middle_initial' => $middle_initial,
									'email' => $email,
									'phone' => $phone,
									'phone_e164' => $phone_e164,
									'position' => $position,
									'birth' => $birth,
									'home_address' => $home_address,
									'country' => $country,
									'state_province' => $state_province,
									'city' => $city,
									'zip' => $zip,
									'ssn' => $ssn,
									'emergency_first_name' => $emergency_first_name,
									'emergency_last_name' => $emergency_last_name,
									'emergency_email' => $emergency_email,
									'emergency_phone' => $emergency_phone,
									'dui' => $dui,
									'convicted' => $convicted,
									'ln' => $ln,
									'ls' => $ls,
									'licenceIssuing' => $licenceIssuing,
									'licence_expiration' => $licence_expiration,
									'years_of_driving_experience' => $years_of_driving_experience,
									'manual_transmision' => $manual_transmision,
									'accident' => $accident,
									'denied_license' => $denied_license,
									'denied_license_explaination' => $denied_license_explaination,
									'suspended_license' => $suspended_license,
									'suspended_license_explaination' => $suspended_license_explaination,
									'team_solo_both' => $team_solo_both,
									'previous_employer_contact' => $previous_employer_contact,
									'otr_or_regional' => $otr_or_regional,
									'english_fluently' => $english_fluently,
									'other_language' => $other_language,
									'recruiter' => $recruiter,
									'status' => 'unprocessed',
									'uid' => $uid
		                            
		                        )
		                    );
		                } catch(PDOException $e) { $errors[] = $e->getMessage();}

		            

		                

		        
		    } catch(PDOException $e) { $errors[] = $e->getMessage();}

		}

		} else  {

			// Wrong Excel format
			header("Location: /en/leads/all/?error=unknown-format"); exit;
		}

		if(isset($errors) && !empty($errors)) {


			var_dump($errors); exit;
			// // DataBase Error
			header("Location: /en/leads/all/?error=db-corrupt"); exit;

		} else {

			// // Success
			header("Location: /en/leads/all/?success"); exit;
		}


	} else {

		// File has not been uploaded
		header("Location: /en/leads/all/?error=upload-failed"); exit;
 
	}

}


