<?php

/* Config
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/_config/_config.php";


/* Templateing & Caching System - Start
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/TemplatingSystemStart.php";


/* Private
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/_libraries/login/private.php";


/* Cache Start
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/CachingStart.php";


/* Output page
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/OutputPage.php";

/* Required Calls
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/RequiredCalls.php";

/* Systems Handle & Control
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/SystemsHandle.php";
  
/* Content
**************************************************** */









$sources = api_call('/GET/sources/?active=1',true,$_SESSION['user']['token']);
   
if(isset($sources['data']['sources']) && $sources['data']['sources']!='') {

    $smarty->assign( 'sources', $sources['data']['sources']);

} 


    
 $position='';
 if(isset($_REQUEST['position']) && $_REQUEST['position']!='') {

 	if($_REQUEST['position']!='all') {

 		$position = "&position=".$_REQUEST['position']."";
 
 	} else {

 		$position = "";
 	}
 
 	$smarty->assign('position_form', $_REQUEST['position']);
 }


 $status='';
  if(isset($_REQUEST['status']) && $_REQUEST['status']!='') {

  	if($_REQUEST['status']!='all') {

 		$status = "&status=".$_REQUEST['status']."";
  	
  	} else {

		$status= "";  		
  	}
 	
 	$smarty->assign('status_form', $_REQUEST['status']);
 }


 $source='';
  if(isset($_REQUEST['source']) && $_REQUEST['source']!='') {

    if($_REQUEST['source']!='all') {

    $source = "&source=".$_REQUEST['source']."";
    
    } else {

    $source= "";      
    }
  
  $smarty->assign('source_form', $_REQUEST['source']);
 }


 $ref='';
  if(isset($_REQUEST['ref']) && $_REQUEST['ref']!='') {

    if($_REQUEST['ref']!='all') {

    $ref = "&ref=".$_REQUEST['ref']."";
    
    } else {

    $ref= "";      
    }
  
  $smarty->assign('ref_form', $_REQUEST['ref']);
 }


if(in_array("recruiting-manager", $_SESSION['user']['obligations_arr'])) {

  $recruiter = '';

} elseif(in_array("recruiter", $_SESSION['user']['obligations_arr']))  {

  $recruiter = "&recruiter=".$_SESSION['user']['uid']."";

}



$list_leads = api_call('/GET/recruiting/leads/?limit=false&active=1'.$recruiter.$position.$status.$source.$ref.'',true,$_SESSION['user']['token']);

if(isset($list_leads['data']['leads']) && !empty($list_leads['data']['leads'])) {

	$smarty->assign('list_leads', $list_leads['data']['leads']);

}


$leadsArr['leads'] = array();

if(isset($list_leads['data']['leads']) && $list_leads['data']['leads']!='') {
    foreach ($list_leads['data']['leads'] as $lead) {

        // className: "fc-event-solid-info fc-event-light",
        
        if($lead['status']=='no-answer' || $lead['status']=='not-interested' || $lead['status']=='not-qualified' || $lead['status']=='terminated' || $lead['status']=='rejected') {
            $className = "fc-event-danger";
        } elseif($lead['status']=='hired') {
            $className = "fc-event-success";
        } else {
            $className = "fc-event-primary";
        }
        
        $tempArr = array(
        
            'title' => "[".$lead['id']."] ".$lead['first_name']." - ".$lead['last_name']."", 
            'description' => "Status: ".$lead['status']."",
            'start' => date_format (new DateTime($lead['updated_at']), 'Y-m-d\TH:i:s'), 
            'id' => $lead['id'],
            'status'=> $lead['status'],
            'className' => $className,
        
        );

        array_push ($leadsArr['leads'], $tempArr);


    }
}


$events_json = json_encode($leadsArr['leads'], true);

$smarty->assign('events', $events_json);







$list_recruiters = api_call('/GET/users/?active=1&orderBy=id&limit=false&obligation=recruiter',true,$_SESSION['user']['token']);
$smarty->assign( 'list_recruiters', $list_recruiters['data']['users'] );

 
$smarty->assign( 'websiteUrl', $websiteUrl );
$smarty->assign( 'page_name', $output_page );
$smarty->display( ''.$output_page.'.html' );
	
