<?php

/* Config
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/_config/_config.php";


/* Templateing & Caching System - Start
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/TemplatingSystemStart.php";


/* Private
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/_libraries/login/private.php";


/* Cache Start
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/CachingStart.php";


/* Output page
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/OutputPage.php";

/* Required Calls
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/RequiredCalls.php";

/* Systems Handle & Control
**************************************************** */
    require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/SystemsHandle.php";
  
/* Content
**************************************************** */
    if(isset($_REQUEST['tab'])) {
        $smarty->assign('tab', $_REQUEST['tab']);
    } else {
        $smarty->assign('tab', '');
    }


    $sources = api_call('/GET/sources/?active=1',true,$_SESSION['user']['token']);
   
    if(isset($sources['data']['sources']) && $sources['data']['sources']!='') {

        $smarty->assign( 'sources', $sources['data']['sources']);

    } 
    

    $single_lead = api_call('/GET/recruiting/leads/?id='.$_REQUEST['id'].'&active=1', true, $_SESSION['user']['token']);


    $list_recruiters = api_call('/GET/users/?active=1&orderBy=id&limit=false&obligation=recruiter',true,$_SESSION['user']['token']);
    $smarty->assign( 'list_recruiters', $list_recruiters['data']['users'] );



    // IF LEAD EXIST
    if(isset($single_lead['data']['leads'][0]) && !empty($single_lead['data']['leads'][0])) {


            // MANAGER
            if(in_array("recruiting-manager", $_SESSION['user']['obligations_arr'])) {

                $smarty->assign( 'single_lead', $single_lead['data']['leads'][0]);

                $recipient_num = urlencode($single_lead['data']['leads'][0]['phone_e164']);

                $list_sms = api_call('/GET/recruiting/sms/?recipient='.$recipient_num.'&limit=false', true, $_SESSION['user']['token']);

                if(isset($list_sms['data']['sms']) && $list_sms['data']['sms']!=='') {
                    $smarty->assign( 'list_sms', $list_sms['data']['sms']);
                    $smarty->assign('total_messages', $list_sms['pagination']['total']);
                } else {

                    $smarty->assign('total_messages', 0);
                }


            // RECRUITER
            } elseif(in_array("recruiter", $_SESSION['user']['obligations_arr'])) {

                // CHECK UID
                if($_SESSION['user']['uid'] == $single_lead['data']['leads'][0]['recruiter']) {

                    $smarty->assign( 'single_lead', $single_lead['data']['leads'][0]);

                    $recipient_num = urlencode($single_lead['data']['leads'][0]['phone_e164']);

                    $list_sms = api_call('/GET/recruiting/sms/?recipient='.$recipient_num.'&limit=false', true, $_SESSION['user']['token']);

                    if(isset($list_sms['data']['sms']) && $list_sms['data']['sms']!=='') {
                        $smarty->assign( 'list_sms', $list_sms['data']['sms']);
                        $smarty->assign('total_messages', $list_sms['pagination']['total']);
                    } else {

                        $smarty->assign('total_messages', 0);
                    }

                } else {

                    header("Location: /".$language."/dashboard/?err=accessDenied"); exit;
                
                }


            }

    } else {

        header("Location: /".$language."/dashboard/?err=notExist"); exit;

    }


/* Templateing & Caching System - End
**************************************************** */
   require $_SERVER["DOCUMENT_ROOT"]."/recruiting/_includes/TemplatingSystemEnd.php";